/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.multiblock;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import nc.config.NCConfig;
import nc.init.NCBlocks;
import nc.init.NCCoolantFluids;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.IngredientSorption;
import nc.recipe.RecipeHelper;
import nc.recipe.RecipeInfo;
import nc.recipe.RecipeMatchResult;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.tile.internal.fluid.Tank;
import nc.util.PermutationHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class CoolantHeaterRecipes
extends BasicRecipeHandler {
    public CoolantHeaterRecipes() {
        super("coolant_heater", 1, 1, 0, 1);
    }

    @Override
    public void addRecipes() {
        this.addRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 0), CoolantHeaterRecipes.fluidStack("nak", 1), CoolantHeaterRecipes.fluidStack("nak_hot", 1), NCConfig.fission_heater_cooling_rate[0], "standard_heater");
        for (int i = 1; i < NCCoolantFluids.COOLANTS.size(); ++i) {
            ItemStack heater = new ItemStack(i < 16 ? NCBlocks.salt_fission_heater : NCBlocks.salt_fission_heater2, 1, i % 16);
            String ruleName = NCCoolantFluids.COOLANTS.get(i) + "_heater";
            this.addRecipe(heater, CoolantHeaterRecipes.fluidStack(NCCoolantFluids.COOLANTS.get(i) + "_nak", 1), CoolantHeaterRecipes.fluidStack(NCCoolantFluids.COOLANTS.get(i) + "_nak_hot", 1), NCConfig.fission_heater_cooling_rate[i], ruleName);
        }
    }

    @Override
    public List<Object> fixExtras(List<Object> extras) {
        ArrayList<Object> fixed = new ArrayList<Object>(2);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Integer ? (Integer)extras.get(0) : 0);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof String ? (String)extras.get(1) : "");
        return fixed;
    }

    @Nullable
    public RecipeInfo<BasicRecipe> getRecipeInfoFromHeaterInputs(String heaterType, List<Tank> fluidInputs) {
        long hash = 31L * (long)(heaterType + "_heater").hashCode() + RecipeHelper.hashMaterialsRaw(new ArrayList<ItemStack>(), fluidInputs);
        if (this.recipeCache.containsKey(hash)) {
            ObjectSet set = (ObjectSet)this.recipeCache.get(hash);
            for (BasicRecipe recipe : set) {
                CoolantHeaterRecipe heaterRecipe;
                RecipeMatchResult matchResult;
                if (!(recipe instanceof CoolantHeaterRecipe) || !(matchResult = (heaterRecipe = (CoolantHeaterRecipe)recipe).matchHeaterInputs(heaterType, fluidInputs)).matches()) continue;
                return new RecipeInfo<BasicRecipe>(heaterRecipe, matchResult);
            }
        }
        return null;
    }

    @Override
    protected void fillHashCache() {
        for (BasicRecipe recipe : this.recipeList) {
            ArrayList<Pair<List<ItemStack>, List<FluidStack>>> materialListTuples;
            if (!this.prepareMaterialListTuples(recipe, materialListTuples = new ArrayList<Pair<List<ItemStack>, List<FluidStack>>>())) continue;
            for (Pair pair : materialListTuples) {
                for (List<FluidStack> list : PermutationHelper.permutations((List)pair.getRight())) {
                    long hash = 31L * (long)recipe.getCoolantHeaterPlacementRule().hashCode() + RecipeHelper.hashMaterials(new ArrayList<ItemStack>(), list);
                    if (this.recipeCache.containsKey(hash)) {
                        ((ObjectSet)this.recipeCache.get(hash)).add((Object)recipe);
                        continue;
                    }
                    ObjectOpenHashSet set = new ObjectOpenHashSet();
                    set.add((Object)recipe);
                    this.recipeCache.put(hash, (Object)set);
                }
            }
        }
    }

    @Override
    public BasicRecipe newRecipe(List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients, List<IItemIngredient> itemProducts, List<IFluidIngredient> fluidProducts, List<Object> extras, boolean shapeless) {
        return new CoolantHeaterRecipe(itemIngredients, fluidIngredients, itemProducts, fluidProducts, extras, shapeless);
    }

    public static class CoolantHeaterRecipe
    extends BasicRecipe {
        public CoolantHeaterRecipe(List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients, List<IItemIngredient> itemProducts, List<IFluidIngredient> fluidProducts, List<Object> extras, boolean shapeless) {
            super(itemIngredients, fluidIngredients, itemProducts, fluidProducts, extras, shapeless);
        }

        public RecipeMatchResult matchHeaterInputs(String heaterType, List<Tank> fluidInputs) {
            if (!this.getCoolantHeaterPlacementRule().equals(heaterType + "_heater")) {
                return RecipeMatchResult.FAIL;
            }
            return RecipeHelper.matchIngredients(IngredientSorption.INPUT, new ArrayList<IItemIngredient>(), this.fluidIngredients, new ArrayList(), fluidInputs, this.isShapeless);
        }
    }
}

