/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.multiblock;

import java.util.ArrayList;
import java.util.List;
import nc.config.NCConfig;
import nc.recipe.BasicRecipeHandler;

public class SaltFissionRecipes
extends BasicRecipeHandler {
    public SaltFissionRecipes() {
        super("salt_fission", 0, 1, 0, 1);
    }

    @Override
    public void addRecipes() {
        this.addFuelDepleteRecipes(NCConfig.fission_thorium_fuel_time, NCConfig.fission_thorium_heat_generation, NCConfig.fission_thorium_efficiency, NCConfig.fission_thorium_criticality, NCConfig.fission_thorium_decay_factor, NCConfig.fission_thorium_self_priming, NCConfig.fission_thorium_radiation, "tbu");
        this.addFuelDepleteRecipes(NCConfig.fission_uranium_fuel_time, NCConfig.fission_uranium_heat_generation, NCConfig.fission_uranium_efficiency, NCConfig.fission_uranium_criticality, NCConfig.fission_uranium_decay_factor, NCConfig.fission_uranium_self_priming, NCConfig.fission_uranium_radiation, "leu_233", "heu_233", "leu_235", "heu_235");
        this.addFuelDepleteRecipes(NCConfig.fission_neptunium_fuel_time, NCConfig.fission_neptunium_heat_generation, NCConfig.fission_neptunium_efficiency, NCConfig.fission_neptunium_criticality, NCConfig.fission_neptunium_decay_factor, NCConfig.fission_neptunium_self_priming, NCConfig.fission_neptunium_radiation, "len_236", "hen_236");
        this.addFuelDepleteRecipes(NCConfig.fission_plutonium_fuel_time, NCConfig.fission_plutonium_heat_generation, NCConfig.fission_plutonium_efficiency, NCConfig.fission_plutonium_criticality, NCConfig.fission_plutonium_decay_factor, NCConfig.fission_plutonium_self_priming, NCConfig.fission_plutonium_radiation, "lep_239", "hep_239", "lep_241", "hep_241");
        this.addFuelDepleteRecipes(NCConfig.fission_mixed_fuel_time, NCConfig.fission_mixed_heat_generation, NCConfig.fission_mixed_efficiency, NCConfig.fission_mixed_criticality, NCConfig.fission_mixed_decay_factor, NCConfig.fission_mixed_self_priming, NCConfig.fission_mixed_radiation, "mix_239", "mix_241");
        this.addFuelDepleteRecipes(NCConfig.fission_americium_fuel_time, NCConfig.fission_americium_heat_generation, NCConfig.fission_americium_efficiency, NCConfig.fission_americium_criticality, NCConfig.fission_americium_decay_factor, NCConfig.fission_americium_self_priming, NCConfig.fission_americium_radiation, "lea_242", "hea_242");
        this.addFuelDepleteRecipes(NCConfig.fission_curium_fuel_time, NCConfig.fission_curium_heat_generation, NCConfig.fission_curium_efficiency, NCConfig.fission_curium_criticality, NCConfig.fission_curium_decay_factor, NCConfig.fission_curium_self_priming, NCConfig.fission_curium_radiation, "lecm_243", "hecm_243", "lecm_245", "hecm_245", "lecm_247", "hecm_247");
        this.addFuelDepleteRecipes(NCConfig.fission_berkelium_fuel_time, NCConfig.fission_berkelium_heat_generation, NCConfig.fission_berkelium_efficiency, NCConfig.fission_berkelium_criticality, NCConfig.fission_berkelium_decay_factor, NCConfig.fission_berkelium_self_priming, NCConfig.fission_berkelium_radiation, "leb_248", "heb_248");
        this.addFuelDepleteRecipes(NCConfig.fission_californium_fuel_time, NCConfig.fission_californium_heat_generation, NCConfig.fission_californium_efficiency, NCConfig.fission_californium_criticality, NCConfig.fission_californium_decay_factor, NCConfig.fission_californium_self_priming, NCConfig.fission_californium_radiation, "lecf_249", "hecf_249", "lecf_251", "hecf_251");
    }

    public void addFuelDepleteRecipes(int[] time, int[] heat, double[] efficiency, int[] criticality, double[] decayFactor, boolean[] selfPriming, double[] radiation, String ... fuelTypes) {
        int id = 0;
        for (String fuelType : fuelTypes) {
            this.addRecipe(SaltFissionRecipes.fluidStack(fuelType + "_fluoride_flibe", 1), SaltFissionRecipes.fluidStack("depleted_" + fuelType + "_fluoride_flibe", 1), (double)time[id + 4] / 144.0, heat[id + 4], efficiency[id + 4], criticality[id + 4], decayFactor[id + 4], selfPriming[id + 4], radiation[id + 4]);
            id += 5;
        }
    }

    @Override
    public List<Object> fixExtras(List<Object> extras) {
        ArrayList<Object> fixed = new ArrayList<Object>(7);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Double ? (Double)extras.get(0) : 1.0);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Integer ? (Integer)extras.get(1) : 0);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Double ? (Double)extras.get(2) : 0.0);
        fixed.add(extras.size() > 3 && extras.get(3) instanceof Integer ? (Integer)extras.get(3) : 1);
        fixed.add(extras.size() > 4 && extras.get(4) instanceof Double ? (Double)extras.get(4) : 0.0);
        fixed.add(extras.size() > 5 && extras.get(5) instanceof Boolean ? (Boolean)extras.get(5) : false);
        fixed.add(extras.size() > 6 && extras.get(6) instanceof Double ? (Double)extras.get(6) : 0.0);
        return fixed;
    }

    @Override
    public List<Object> getFactoredExtras(List<Object> extras, int factor) {
        ArrayList<Object> factored = new ArrayList<Object>(extras);
        factored.set(0, (Integer)extras.get(0) / factor);
        return factored;
    }
}

