/*
 * Decompiled with CFR 0.152.
 */
package nc.render.tile;

import it.unimi.dsi.fastutil.ints.IntListIterator;
import javax.vecmath.Vector3f;
import nc.config.NCConfig;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.TurbineRotorBladeUtil;
import nc.multiblock.turbine.tile.TileTurbineController;
import nc.util.NCMath;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderTurbineRotor
extends TileEntitySpecialRenderer<TileTurbineController> {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private final float[] brightness = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private byte count = 0;
    private long prevRenderTime = 0L;

    public boolean isGlobalRenderer(TileTurbineController tile) {
        return tile.isRenderer() && tile.isMultiblockAssembled();
    }

    public void render(TileTurbineController controller, double posX, double posY, double posZ, float partialTicks, int destroyStage, float alpha) {
        int depth;
        if (!controller.isRenderer() || !controller.isMultiblockAssembled()) {
            return;
        }
        Turbine turbine = (Turbine)controller.getMultiblock();
        if (turbine == null || turbine.nbtUpdateRenderDataFlag) {
            return;
        }
        int flowLength = turbine.getFlowLength();
        int bladeLength = turbine.bladeLength;
        int shaftWidth = turbine.shaftWidth;
        if (flowLength < 1 || turbine.renderPosArray == null || turbine.bladeAngleArray == null || turbine.rotorStateArray == null || turbine.rotorStateArray.length < 1 + 4 * flowLength) {
            return;
        }
        IBlockState shaftState = turbine.rotorStateArray[4 * flowLength];
        EnumFacing dir = turbine.flowDir;
        if (shaftState == null || dir == null) {
            return;
        }
        BlockRendererDispatcher renderer = MC.func_175602_ab();
        this.brightness[this.count] = controller.func_145831_w().func_175724_o(turbine.getExtremeInteriorCoord(NCMath.getBit(this.count, 0) == 1, NCMath.getBit(this.count, 1) == 1, NCMath.getBit(this.count, 2) == 1));
        this.count = (byte)(this.count + 1);
        this.count = (byte)(this.count % 8);
        float bright = (this.brightness[0] + this.brightness[1] + this.brightness[2] + this.brightness[3] + this.brightness[4] + this.brightness[5] + this.brightness[6] + this.brightness[7]) / 8.0f;
        RenderTurbineRotor.MC.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)0.0f, (float)240.0f);
        BlockPos pos = controller.func_174877_v();
        double r = turbine.getRotorRadius();
        double scale = r / Math.sqrt(r * r + (double)NCMath.sq(shaftWidth) / 4.0);
        double rX = (double)(-turbine.getMaxX() + pos.func_177958_n()) + (dir.func_176740_k() == EnumFacing.Axis.X ? 0.0 : r);
        double rY = (double)(-turbine.getMaxY() + pos.func_177956_o()) + (dir.func_176740_k() == EnumFacing.Axis.Y ? 0.0 : r);
        double rZ = (double)(-turbine.getMaxZ() + pos.func_177952_p()) + (dir.func_176740_k() == EnumFacing.Axis.Z ? 0.0 : r);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(posX - rX), (double)(posY - rY), (double)(posZ - rZ));
        GlStateManager.func_179139_a((double)(dir.func_176740_k() == EnumFacing.Axis.X ? 1.0 : scale), (double)(dir.func_176740_k() == EnumFacing.Axis.Y ? 1.0 : scale), (double)(dir.func_176740_k() == EnumFacing.Axis.Z ? 1.0 : scale));
        long systemTime = Minecraft.func_71386_F();
        if (!MC.func_147113_T()) {
            turbine.rotorAngle = (turbine.rotorAngle + (float)(systemTime - this.prevRenderTime) * turbine.angVel) % 360.0f;
        }
        this.prevRenderTime = systemTime;
        GlStateManager.func_179114_b((float)turbine.rotorAngle, (float)(dir.func_176740_k() == EnumFacing.Axis.X ? 1.0f : 0.0f), (float)(dir.func_176740_k() == EnumFacing.Axis.Y ? 1.0f : 0.0f), (float)(dir.func_176740_k() == EnumFacing.Axis.Z ? 1.0f : 0.0f));
        GlStateManager.func_179137_b((double)((double)(-pos.func_177958_n()) + rX), (double)((double)(-pos.func_177956_o()) + rY), (double)((double)(-pos.func_177952_p()) + rZ));
        IntListIterator intListIterator = turbine.bladeDepths.iterator();
        while (intListIterator.hasNext()) {
            depth = (Integer)intListIterator.next();
            this.renderRotor(turbine, renderer, bright, shaftState, dir, flowLength, bladeLength, shaftWidth, NCConfig.turbine_render_blade_width, depth);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        pos = controller.func_174877_v();
        GlStateManager.func_179137_b((double)(posX - rX), (double)(posY - rY), (double)(posZ - rZ));
        GlStateManager.func_179139_a((double)(dir.func_176740_k() == EnumFacing.Axis.X ? 1.0 : scale), (double)(dir.func_176740_k() == EnumFacing.Axis.Y ? 1.0 : scale), (double)(dir.func_176740_k() == EnumFacing.Axis.Z ? 1.0 : scale));
        GlStateManager.func_179137_b((double)((double)(-pos.func_177958_n()) + rX), (double)((double)(-pos.func_177956_o()) + rY), (double)((double)(-pos.func_177952_p()) + rZ));
        intListIterator = turbine.statorDepths.iterator();
        while (intListIterator.hasNext()) {
            depth = (Integer)intListIterator.next();
            this.renderRotor(turbine, renderer, bright, shaftState, dir, flowLength, bladeLength, shaftWidth, NCConfig.turbine_render_blade_width, depth);
        }
        GlStateManager.func_179121_F();
    }

    public void renderRotor(Turbine turbine, BlockRendererDispatcher renderer, float bright, IBlockState shaftState, EnumFacing flowDir, int flowLength, int bladeLength, int shaftWidth, double bladeWidth, int depth) {
        double depthScale = Math.pow(NCConfig.turbine_render_rotor_expansion, (double)(1 + depth - flowLength) / (double)flowLength);
        GlStateManager.func_179094_E();
        if (turbine.renderPosArray.length < 1 + 4 * flowLength * shaftWidth + depth) {
            return;
        }
        Vector3f renderPos = turbine.renderPosArray[4 * flowLength * shaftWidth + depth];
        GlStateManager.func_179137_b((double)((double)renderPos.x + 0.5), (double)((double)renderPos.y + 0.5), (double)((double)renderPos.z + 0.5));
        GlStateManager.func_179139_a((double)(flowDir.func_176740_k() == EnumFacing.Axis.X ? 1.0 : depthScale), (double)(flowDir.func_176740_k() == EnumFacing.Axis.Y ? 1.0 : depthScale), (double)(flowDir.func_176740_k() == EnumFacing.Axis.Z ? 1.0 : depthScale));
        GlStateManager.func_179137_b((double)((double)(-renderPos.x) - 0.5), (double)((double)(-renderPos.y) - 0.5), (double)((double)(-renderPos.z) - 0.5));
        this.renderShaft(turbine, renderer, bright, shaftState, flowDir, flowLength, shaftWidth, depth);
        for (int j : new int[]{0, flowLength, 2 * flowLength, 3 * flowLength}) {
            this.renderBlades(turbine, renderer, bright, flowDir, flowLength, bladeLength, shaftWidth, bladeWidth, j, depth);
        }
        GlStateManager.func_179121_F();
    }

    public void renderShaft(Turbine turbine, BlockRendererDispatcher renderer, float bright, IBlockState shaftState, EnumFacing flowDir, int flowLength, int shaftWidth, int depth) {
        GlStateManager.func_179094_E();
        if (turbine.renderPosArray.length < 1 + 4 * flowLength * shaftWidth + depth) {
            return;
        }
        Vector3f renderPos = turbine.renderPosArray[4 * flowLength * shaftWidth + depth];
        GlStateManager.func_179137_b((double)((double)renderPos.x + 0.5), (double)((double)renderPos.y + 0.5), (double)((double)renderPos.z + 0.5));
        GlStateManager.func_179139_a((double)(flowDir.func_176740_k() == EnumFacing.Axis.X ? 1.0 : (double)shaftWidth), (double)(flowDir.func_176740_k() == EnumFacing.Axis.Y ? 1.0 : (double)shaftWidth), (double)(flowDir.func_176740_k() == EnumFacing.Axis.Z ? 1.0 : (double)shaftWidth));
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        renderer.func_175016_a(shaftState, bright);
        GlStateManager.func_179121_F();
    }

    public void renderBlades(Turbine turbine, BlockRendererDispatcher renderer, float bright, EnumFacing flowDir, int flowLength, int bladeLength, int shaftWidth, double bladeWidth, int jMult, int depth) {
        int i = jMult + depth;
        if (turbine.rotorStateArray.length < i + 1) {
            return;
        }
        for (int w = 0; w < shaftWidth; ++w) {
            GlStateManager.func_179094_E();
            Vector3f renderPos = turbine.renderPosArray[w + i * shaftWidth];
            IBlockState rotorState = turbine.rotorStateArray[i];
            TurbineRotorBladeUtil.TurbinePartDir bladeDir = (TurbineRotorBladeUtil.TurbinePartDir)((Object)rotorState.func_177229_b(TurbineRotorBladeUtil.DIR));
            Turbine.PlaneDir planeDir = i < flowLength || i >= 3 * flowLength ? Turbine.PlaneDir.V : Turbine.PlaneDir.U;
            GlStateManager.func_179137_b((double)((double)renderPos.x + 0.5), (double)((double)renderPos.y + 0.5), (double)((double)renderPos.z + 0.5));
            GlStateManager.func_179139_a((double)(flowDir.func_176740_k() == EnumFacing.Axis.X ? 1.0 : (turbine.getBladeDir(planeDir) == TurbineRotorBladeUtil.TurbinePartDir.X ? (double)bladeLength : bladeWidth)), (double)(flowDir.func_176740_k() == EnumFacing.Axis.Y ? 1.0 : (turbine.getBladeDir(planeDir) == TurbineRotorBladeUtil.TurbinePartDir.Y ? (double)bladeLength : bladeWidth)), (double)(flowDir.func_176740_k() == EnumFacing.Axis.Z ? 1.0 : (turbine.getBladeDir(planeDir) == TurbineRotorBladeUtil.TurbinePartDir.Z ? (double)bladeLength : bladeWidth)));
            GlStateManager.func_179114_b((float)(turbine.bladeAngleArray[i] * (flowDir.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ^ flowDir.func_176740_k() == EnumFacing.Axis.X ? 1.0f : -1.0f)), (float)(bladeDir == TurbineRotorBladeUtil.TurbinePartDir.X ? 1.0f : 0.0f), (float)(bladeDir == TurbineRotorBladeUtil.TurbinePartDir.Y ? 1.0f : 0.0f), (float)(bladeDir == TurbineRotorBladeUtil.TurbinePartDir.Z ? 1.0f : 0.0f));
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            renderer.func_175016_a(rotorState, bright);
            GlStateManager.func_179121_F();
        }
    }
}

