/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.fluid;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import nc.tile.internal.fluid.TankSorption;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class FluidConnection {
    @Nonnull
    private final List<TankSorption> sorptionList;
    @Nonnull
    private final List<TankSorption> defaultSorptions;

    public FluidConnection(@Nonnull List<TankSorption> sorptionList) {
        this.sorptionList = new ArrayList<TankSorption>(sorptionList);
        this.defaultSorptions = new ArrayList<TankSorption>(sorptionList);
    }

    private FluidConnection(@Nonnull FluidConnection connection) {
        this.sorptionList = new ArrayList<TankSorption>(connection.sorptionList);
        this.defaultSorptions = new ArrayList<TankSorption>(connection.defaultSorptions);
    }

    private FluidConnection copy() {
        return new FluidConnection(this);
    }

    public static FluidConnection[] cloneArray(@Nonnull FluidConnection[] connections) {
        FluidConnection[] clone = new FluidConnection[6];
        for (int i = 0; i < 6; ++i) {
            clone[i] = connections[i].copy();
        }
        return clone;
    }

    public TankSorption getTankSorption(int tankNumber) {
        return this.sorptionList.get(tankNumber);
    }

    public void setTankSorption(int tankNumber, TankSorption sorption) {
        this.sorptionList.set(tankNumber, sorption);
    }

    public TankSorption getDefaultTankSorption(int slot) {
        return this.defaultSorptions.get(slot);
    }

    public boolean canConnect() {
        for (TankSorption sorption : this.sorptionList) {
            if (!sorption.canConnect()) continue;
            return true;
        }
        return false;
    }

    public void toggleTankSorption(int tankNumber, TankSorption.Type type, boolean reverse) {
        this.setTankSorption(tankNumber, this.getTankSorption(tankNumber).next(type, reverse));
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound nbt, @Nonnull EnumFacing side) {
        NBTTagCompound connectionTag = new NBTTagCompound();
        for (int i = 0; i < this.sorptionList.size(); ++i) {
            connectionTag.func_74768_a("sorption" + i, this.getTankSorption(i).ordinal());
        }
        nbt.func_74782_a("fluidConnection" + side.func_176745_a(), (NBTBase)connectionTag);
        return nbt;
    }

    public final FluidConnection readFromNBT(NBTTagCompound nbt, @Nonnull EnumFacing side) {
        if (nbt.func_74764_b("fluidConnection" + side.func_176745_a())) {
            NBTTagCompound connectionTag = nbt.func_74775_l("fluidConnection" + side.func_176745_a());
            for (int i = 0; i < this.sorptionList.size(); ++i) {
                if (!connectionTag.func_74764_b("sorption" + i)) continue;
                this.setTankSorption(i, TankSorption.values()[connectionTag.func_74762_e("sorption" + i)]);
            }
        }
        return this;
    }
}

