/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IngredientOr;
import java.util.ArrayList;
import lach_01298.qmd.crafttweaker.particle.IParticleStack;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.recipe.QMDRecipeHelper;
import lach_01298.qmd.recipe.ingredient.EmptyParticleIngredient;
import lach_01298.qmd.recipe.ingredient.IParticleIngredient;
import lach_01298.qmd.recipe.ingredient.ParticleIngredient;

public class QMDCTHelper {
    public static ParticleStack getParticleStack(IParticleStack stack) {
        if (stack == null) {
            return null;
        }
        Object internal = stack.getInternal();
        if (!(internal instanceof ParticleStack)) {
            CraftTweakerAPI.logError((String)("Not a valid particle stack: " + stack));
        }
        return ((ParticleStack)internal).copy();
    }

    public static IParticleIngredient buildAdditionParticleIngredient(IIngredient ingredient) {
        if (ingredient == null) {
            return new EmptyParticleIngredient();
        }
        if (ingredient instanceof IParticleStack) {
            return QMDRecipeHelper.buildParticleIngredient(QMDCTHelper.getParticleStack((IParticleStack)ingredient));
        }
        if (ingredient instanceof IngredientOr) {
            return QMDCTHelper.buildAdditionParticleIngredientArray((IngredientOr)ingredient);
        }
        CraftTweakerAPI.logError((String)String.format("QMD: Invalid ingredient: %s, %s", ingredient.getClass().getName(), ingredient));
        return null;
    }

    public static IParticleIngredient buildRemovalParticleIngredient(IIngredient ingredient) {
        if (ingredient == null) {
            return new EmptyParticleIngredient();
        }
        if (ingredient instanceof IParticleStack) {
            return new ParticleIngredient(((IParticleStack)ingredient).getName(), ((IParticleStack)ingredient).getAmount(), ((IParticleStack)ingredient).getMeanEnergy(), ((IParticleStack)ingredient).getFocus());
        }
        if (ingredient instanceof IngredientOr) {
            return QMDCTHelper.buildRemovalParticleIngredientArray((IngredientOr)ingredient);
        }
        CraftTweakerAPI.logError((String)String.format("QMD: Invalid ingredient: %s, %s", ingredient.getClass().getName(), ingredient));
        return null;
    }

    public static IParticleIngredient buildAdditionParticleIngredientArray(IngredientOr ingredient) {
        if (!(ingredient.getInternal() instanceof IIngredient[])) {
            CraftTweakerAPI.logError((String)String.format("QMD: Invalid ingredient: %s, %s", ingredient.getClass().getName(), ingredient));
            return null;
        }
        ArrayList<IParticleIngredient> ingredientList = new ArrayList<IParticleIngredient>();
        for (IIngredient ctIngredient : (IIngredient[])ingredient.getInternal()) {
            ingredientList.add(QMDCTHelper.buildAdditionParticleIngredient(ctIngredient));
        }
        return QMDRecipeHelper.buildParticleIngredient(ingredientList);
    }

    public static IParticleIngredient buildRemovalParticleIngredientArray(IngredientOr ingredient) {
        if (!(ingredient.getInternal() instanceof IIngredient[])) {
            CraftTweakerAPI.logError((String)String.format("QMD: Invalid ingredient: %s, %s", ingredient.getClass().getName(), ingredient));
            return null;
        }
        ArrayList<IParticleIngredient> ingredientList = new ArrayList<IParticleIngredient>();
        for (IIngredient ctIngredient : (IIngredient[])ingredient.getInternal()) {
            ingredientList.add(QMDCTHelper.buildRemovalParticleIngredient(ctIngredient));
        }
        return QMDRecipeHelper.buildParticleIngredient(ingredientList);
    }
}

