/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.multiblock.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.particle.ParticleStorage;
import lach_01298.qmd.particle.ParticleStorageAccelerator;
import lach_01298.qmd.util.ByteUtil;
import nc.network.multiblock.MultiblockUpdatePacket;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.fluid.Tank;
import net.minecraft.util.math.BlockPos;

public class ParticleChamberUpdatePacket
extends MultiblockUpdatePacket {
    public boolean isChamberOn;
    public int requiredEnergy;
    public double efficiency;
    public EnergyStorage energyStorage;
    public byte numberOfTanks;
    public List<Tank.TankInfo> tanksInfo;
    public List<ParticleStorageAccelerator> beams;

    public ParticleChamberUpdatePacket() {
        this.beams = new ArrayList<ParticleStorageAccelerator>();
    }

    public ParticleChamberUpdatePacket(BlockPos pos, boolean isChamberOn, int requiredEnergy, double efficiency, EnergyStorage energyStorage, List<Tank> tanks, List<ParticleStorageAccelerator> beams) {
        this.pos = pos;
        this.isChamberOn = isChamberOn;
        this.requiredEnergy = requiredEnergy;
        this.efficiency = efficiency;
        this.energyStorage = energyStorage;
        this.numberOfTanks = (byte)tanks.size();
        this.tanksInfo = Tank.TankInfo.infoList(tanks);
        this.beams = beams;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.isChamberOn = buf.readBoolean();
        this.requiredEnergy = buf.readInt();
        this.efficiency = buf.readDouble();
        this.energyStorage = ByteUtil.readBufEnergy(buf);
        this.numberOfTanks = buf.readByte();
        this.tanksInfo = Tank.TankInfo.readBuf((ByteBuf)buf, (byte)this.numberOfTanks);
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ParticleStorage storage = ByteUtil.readBufBeam(buf);
            ParticleStorageAccelerator beam = new ParticleStorageAccelerator();
            beam.setParticleStack(storage.getParticleStack());
            beam.setMaxEnergy(storage.getMaxEnergy());
            beam.setMinEnergy(storage.getMinEnergy());
            beam.setCapacity(storage.getCapacity());
            this.beams.add(beam);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.isChamberOn);
        buf.writeInt(this.requiredEnergy);
        buf.writeDouble(this.efficiency);
        ByteUtil.writeBufEnergy(this.energyStorage, buf);
        buf.writeByte((int)this.numberOfTanks);
        for (Tank.TankInfo info : this.tanksInfo) {
            info.writeBuf(buf);
        }
        buf.writeInt(this.beams.size());
        for (ParticleStorageAccelerator beam : this.beams) {
            ByteUtil.writeBufBeam(beam, buf);
        }
    }
}

