/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.network;

import io.netty.buffer.ByteBuf;
import lach_01298.qmd.QMD;
import lach_01298.qmd.entity.EntityLeptonBeam;
import lach_01298.qmd.network.BeamProjectileUpdatePacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class LeptonBeamUpdatePacket
extends BeamProjectileUpdatePacket {
    public int color;

    public LeptonBeamUpdatePacket() {
    }

    public LeptonBeamUpdatePacket(EntityLeptonBeam projectile) {
        super(projectile);
        if (this.validMessage) {
            this.color = projectile.getColor().getRGB();
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.color = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.color);
    }

    public static class Handler
    implements IMessageHandler<LeptonBeamUpdatePacket, IMessage> {
        public IMessage onMessage(LeptonBeamUpdatePacket message, MessageContext ctx) {
            if (ctx.side.isClient() && message.validMessage) {
                EntityPlayer player = QMD.proxy.getPlayerClient();
                if (player.field_70170_p.func_73045_a(message.entityId) instanceof EntityLeptonBeam) {
                    EntityLeptonBeam beam = (EntityLeptonBeam)player.field_70170_p.func_73045_a(message.entityId);
                    if (player.field_70170_p.func_73045_a(message.ownerEntityId) instanceof EntityPlayer) {
                        beam.setOwner((EntityPlayer)player.field_70170_p.func_73045_a(message.ownerEntityId));
                        beam.setLength(message.length);
                        beam.setColour(message.color);
                        if (message.mainHand) {
                            beam.setHand(EnumHand.MAIN_HAND);
                        } else {
                            beam.setHand(EnumHand.OFF_HAND);
                        }
                    }
                }
            }
            return null;
        }
    }
}

