/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.particle;

import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class Particle {
    protected final String name;
    protected final double mass;
    protected final double charge;
    protected final double spin;
    protected final boolean strongInteract;
    protected final boolean weakInteract;
    protected Particle antiparticle;
    protected HashMap<Particle, Integer> componentParticles = new HashMap();
    protected final ResourceLocation texture;

    public Particle(@Nonnull String name, ResourceLocation texture, double mass, double charge, double spin) {
        this.name = name;
        this.texture = texture;
        this.mass = mass;
        this.charge = charge;
        this.spin = spin;
        this.weakInteract = true;
        this.strongInteract = true;
        this.antiparticle = this;
    }

    public Particle(@Nonnull String name, ResourceLocation texture, double mass, double charge, double spin, boolean weakInteract) {
        this.name = name;
        this.texture = texture;
        this.mass = mass;
        this.charge = charge;
        this.spin = spin;
        this.weakInteract = weakInteract;
        this.strongInteract = false;
        this.antiparticle = this;
    }

    public Particle(@Nonnull String name, ResourceLocation texture, double mass, double charge, double spin, boolean weakInteract, boolean strongInteract) {
        this.name = name;
        this.texture = texture;
        this.mass = mass;
        this.charge = charge;
        this.spin = spin;
        this.weakInteract = weakInteract;
        this.strongInteract = strongInteract;
        this.antiparticle = this;
    }

    public String getName() {
        return this.name;
    }

    public double getMass() {
        return this.mass;
    }

    public double getCharge() {
        return this.charge;
    }

    public double getSpin() {
        return this.spin;
    }

    public void setAntiParticle(Particle antiparticle) {
        this.antiparticle = antiparticle;
        antiparticle.antiparticle = this;
    }

    public Particle getAntiParticle() {
        return this.antiparticle;
    }

    public void addComponentParticle(Particle component) {
        if (this.componentParticles.containsKey(component)) {
            this.componentParticles.replace(component, this.componentParticles.get(component) + 1);
        } else {
            this.componentParticles.put(component, 1);
        }
    }

    public void addComponentParticle(Particle component, int amount) {
        if (this.componentParticles.containsKey(component)) {
            this.componentParticles.replace(component, this.componentParticles.get(component) + amount);
        } else {
            this.componentParticles.put(component, amount);
        }
    }

    public void setComponentParticles(HashMap<Particle, Integer> particles) {
        this.componentParticles = particles;
    }

    public HashMap<Particle, Integer> getComponentParticles() {
        return this.componentParticles;
    }

    public boolean hasComponentParticles() {
        return !this.componentParticles.isEmpty();
    }

    public String getUnlocalizedName() {
        return "qmd.particle." + this.name + ".name";
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public boolean interactsWithEM() {
        return this.charge != 0.0;
    }

    public boolean interactsWithStrong() {
        return this.strongInteract;
    }

    public boolean interactsWithWeak() {
        return this.weakInteract;
    }
}

