/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.recipe;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import lach_01298.qmd.particle.Particle;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.particle.Particles;
import lach_01298.qmd.recipe.AbstractQMDRecipeHandler;
import lach_01298.qmd.recipe.IQMDRecipe;
import lach_01298.qmd.recipe.QMDRecipeHandler;
import lach_01298.qmd.recipe.QMDRecipeMatchResult;
import lach_01298.qmd.recipe.ingredient.EmptyParticleIngredient;
import lach_01298.qmd.recipe.ingredient.IParticleIngredient;
import lach_01298.qmd.recipe.ingredient.ParticleArrayIngredient;
import lach_01298.qmd.recipe.ingredient.ParticleIngredient;
import nc.ModCheck;
import nc.recipe.IngredientMatchResult;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.ChanceFluidIngredient;
import nc.recipe.ingredient.ChanceItemIngredient;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.EmptyItemIngredient;
import nc.recipe.ingredient.FluidArrayIngredient;
import nc.recipe.ingredient.FluidIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.ItemArrayIngredient;
import nc.recipe.ingredient.ItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.tile.internal.fluid.Tank;
import nc.util.CollectionHelper;
import nc.util.FluidRegHelper;
import nc.util.GasHelper;
import nc.util.OreDictHelper;
import nc.util.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class QMDRecipeHelper {
    public static boolean containsItemIngredient(List<IItemIngredient> list, IItemIngredient ingredient) {
        for (IItemIngredient i : list) {
            if (i == null || !i.match((Object)ingredient, IngredientSorption.NEUTRAL).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFluidIngredient(List<IFluidIngredient> list, IFluidIngredient ingredient) {
        for (IFluidIngredient i : list) {
            if (i == null || !i.match((Object)ingredient, IngredientSorption.NEUTRAL).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsParticleIngredient(List<IParticleIngredient> list, IParticleIngredient ingredient) {
        for (IParticleIngredient i : list) {
            if (i == null || !i.match(ingredient, IngredientSorption.NEUTRAL).matches()) continue;
            return true;
        }
        return false;
    }

    public static ItemStack fixItemStack(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ItemStack) {
            ItemStack stack = ((ItemStack)object).func_77946_l();
            if (stack.func_190916_E() <= 0) {
                stack.func_190920_e(1);
            }
            return stack;
        }
        if (object instanceof Item) {
            return new ItemStack((Item)object, 1);
        }
        if (!(object instanceof Block)) {
            throw new RuntimeException(String.format("Invalid ItemStack: %s", object));
        }
        return new ItemStack((Block)object, 1);
    }

    public static FluidStack fixFluidStack(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof FluidStack) {
            FluidStack fluidstack = ((FluidStack)object).copy();
            if (fluidstack.amount <= 0) {
                fluidstack.amount = 1000;
            }
            return fluidstack;
        }
        if (!(object instanceof Fluid)) {
            throw new RuntimeException(String.format("Invalid FluidStack: %s", object));
        }
        return new FluidStack((Fluid)object, 1000);
    }

    public static ParticleStack fixParticleStack(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ParticleStack) {
            ParticleStack stack = ((ParticleStack)object).copy();
            if (stack.getAmount() <= 0) {
                stack.setAmount(1);
            }
            return stack;
        }
        if (!(object instanceof Particle)) {
            throw new RuntimeException(String.format("Invalid ParticleStack: %s", object));
        }
        return new ParticleStack((Particle)object, 0, 1L, 0.0);
    }

    public static OreIngredient oreStackFromString(String name) {
        if (OreDictHelper.oreExists((String)name)) {
            return new OreIngredient(name, 1);
        }
        return null;
    }

    public static FluidIngredient fluidStackFromString(String name) {
        if (FluidRegHelper.fluidExists((String)name)) {
            return new FluidIngredient(name, 1000);
        }
        return null;
    }

    public static ParticleIngredient particleStackFromString(String name) {
        if (Particles.getParticleFromName(name) != null) {
            return new ParticleIngredient(name, 0, 1L, 0.0);
        }
        return null;
    }

    public static List<List<ItemStack>> getItemInputLists(List<IItemIngredient> ingredientList) {
        ArrayList<List<ItemStack>> values = new ArrayList<List<ItemStack>>();
        ingredientList.forEach(ingredient -> values.add(ingredient.getInputStackList()));
        return values;
    }

    public static List<List<FluidStack>> getFluidInputLists(List<IFluidIngredient> ingredientList) {
        ArrayList<List<FluidStack>> values = new ArrayList<List<FluidStack>>();
        ingredientList.forEach(ingredient -> values.add(ingredient.getInputStackList()));
        return values;
    }

    public static List<List<ParticleStack>> getParticleInputLists(List<IParticleIngredient> ingredientList) {
        ArrayList<List<ParticleStack>> values = new ArrayList<List<ParticleStack>>();
        ingredientList.forEach(ingredient -> values.add(ingredient.getInputStackList()));
        return values;
    }

    public static List<List<ItemStack>> getItemOutputLists(List<IItemIngredient> ingredientList) {
        ArrayList<List<ItemStack>> values = new ArrayList<List<ItemStack>>();
        ingredientList.forEach(ingredient -> values.add(QMDRecipeHelper.getItemOutputStackList(ingredient)));
        return values;
    }

    public static List<List<FluidStack>> getFluidOutputLists(List<IFluidIngredient> ingredientList) {
        ArrayList<List<FluidStack>> values = new ArrayList<List<FluidStack>>();
        ingredientList.forEach(ingredient -> values.add(QMDRecipeHelper.getFluidOutputStackList(ingredient)));
        return values;
    }

    public static List<List<ParticleStack>> getParticleOutputLists(List<IParticleIngredient> ingredientList) {
        ArrayList<List<ParticleStack>> values = new ArrayList<List<ParticleStack>>();
        ingredientList.forEach(ingredient -> values.add(QMDRecipeHelper.getParticleOutputStackList(ingredient)));
        return values;
    }

    public static List<ItemStack> getItemOutputStackList(IItemIngredient ingredient) {
        if (ingredient instanceof ChanceItemIngredient) {
            return ingredient.getOutputStackList();
        }
        return Lists.newArrayList((Object[])new ItemStack[]{(ItemStack)ingredient.getStack()});
    }

    public static List<FluidStack> getFluidOutputStackList(IFluidIngredient ingredient) {
        if (ingredient instanceof ChanceFluidIngredient) {
            return ingredient.getOutputStackList();
        }
        return Lists.newArrayList((Object[])new FluidStack[]{(FluidStack)ingredient.getStack()});
    }

    public static List<ParticleStack> getParticleOutputStackList(IParticleIngredient ingredient) {
        return Lists.newArrayList((Object[])new ParticleStack[]{(ParticleStack)ingredient.getStack()});
    }

    @Nullable
    public static List<ItemStack> getItemOutputList(List<IItemIngredient> list) {
        if (list.contains(null)) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        list.forEach(ingredient -> stacks.add((ItemStack)ingredient.getStack()));
        if (stacks.contains(null)) {
            return new ArrayList<ItemStack>();
        }
        return stacks;
    }

    @Nullable
    public static List<FluidStack> getFluidOutputList(List<IFluidIngredient> list) {
        if (list.contains(null)) {
            return new ArrayList<FluidStack>();
        }
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        list.forEach(ingredient -> stacks.add((FluidStack)ingredient.getStack()));
        if (stacks.contains(null)) {
            return new ArrayList<FluidStack>();
        }
        return stacks;
    }

    @Nullable
    public static List<ParticleStack> getParticleOutputList(List<IParticleIngredient> list) {
        if (list.contains(null)) {
            return new ArrayList<ParticleStack>();
        }
        ArrayList<ParticleStack> stacks = new ArrayList<ParticleStack>();
        list.forEach(ingredient -> stacks.add((ParticleStack)ingredient.getStack()));
        if (stacks.contains(null)) {
            return new ArrayList<ParticleStack>();
        }
        return stacks;
    }

    @Nullable
    public static ItemStack getItemStackFromIngredientList(List<IItemIngredient> list, int pos) {
        if (!list.isEmpty() && pos < list.size()) {
            IItemIngredient object = list.get(pos);
            return (ItemStack)object.getStack();
        }
        return null;
    }

    @Nullable
    public static FluidStack getFluidStackFromIngredientList(List<IFluidIngredient> list, int pos) {
        if (!list.isEmpty() && pos < list.size()) {
            IFluidIngredient object = list.get(pos);
            return (FluidStack)object.getStack();
        }
        return null;
    }

    @Nullable
    public static ParticleStack getParticleStackFromIngredientList(List<IParticleIngredient> list, int pos) {
        if (!list.isEmpty() && pos < list.size()) {
            IParticleIngredient object = list.get(pos);
            return (ParticleStack)object.getStack();
        }
        return null;
    }

    @Nullable
    public static IItemIngredient buildItemIngredient(Object object) {
        if (AbstractQMDRecipeHandler.requiresItemFixing(object)) {
            object = QMDRecipeHelper.fixItemStack(object);
        }
        if (object instanceof IItemIngredient) {
            return QMDRecipeHelper.checkedItemIngredient((IItemIngredient)object);
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<IItemIngredient> buildList = new ArrayList<IItemIngredient>();
            if (!list.isEmpty()) {
                for (Object listObject : list) {
                    IItemIngredient recipeObject;
                    if (listObject instanceof IItemIngredient) {
                        buildList.add((IItemIngredient)listObject);
                        continue;
                    }
                    if (listObject == null || (recipeObject = QMDRecipeHelper.checkedItemIngredient(QMDRecipeHelper.buildItemIngredient(listObject))) == null) continue;
                    buildList.add(recipeObject);
                }
                if (buildList.isEmpty()) {
                    return null;
                }
                return QMDRecipeHelper.checkedItemIngredient((IItemIngredient)new ItemArrayIngredient(buildList));
            }
            return null;
        }
        if (object instanceof String) {
            return QMDRecipeHelper.checkedItemIngredient((IItemIngredient)QMDRecipeHelper.oreStackFromString((String)object));
        }
        if (object instanceof ItemStack) {
            return QMDRecipeHelper.checkedItemIngredient((IItemIngredient)new ItemIngredient((ItemStack)object));
        }
        return null;
    }

    @Nullable
    public static IItemIngredient checkedItemIngredient(IItemIngredient ingredient) {
        return ingredient == null || !ingredient.isValid() ? null : ingredient;
    }

    @Nullable
    public static IFluidIngredient buildFluidIngredient(Object object) {
        if (AbstractQMDRecipeHandler.requiresFluidFixing(object)) {
            object = QMDRecipeHelper.fixFluidStack(object);
        }
        if (QMDRecipeHelper.needsExpanding() && object instanceof FluidIngredient) {
            return QMDRecipeHelper.checkedFluidIngredient(QMDRecipeHelper.buildFluidIngredient(QMDRecipeHelper.expandedFluidStackList((FluidIngredient)object)));
        }
        if (object instanceof IFluidIngredient) {
            return QMDRecipeHelper.checkedFluidIngredient((IFluidIngredient)object);
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<IFluidIngredient> buildList = new ArrayList<IFluidIngredient>();
            if (!list.isEmpty()) {
                for (Object listObject : list) {
                    IFluidIngredient recipeObject;
                    if (listObject instanceof IFluidIngredient) {
                        buildList.add((IFluidIngredient)listObject);
                        continue;
                    }
                    if (listObject == null || (recipeObject = QMDRecipeHelper.checkedFluidIngredient(QMDRecipeHelper.buildFluidIngredient(listObject))) == null) continue;
                    buildList.add(recipeObject);
                }
                if (buildList.isEmpty()) {
                    return null;
                }
                return QMDRecipeHelper.checkedFluidIngredient((IFluidIngredient)new FluidArrayIngredient(buildList));
            }
            return null;
        }
        if (object instanceof String) {
            return QMDRecipeHelper.checkedFluidIngredient((IFluidIngredient)QMDRecipeHelper.fluidStackFromString((String)object));
        }
        if (object instanceof FluidStack) {
            return QMDRecipeHelper.checkedFluidIngredient((IFluidIngredient)new FluidIngredient((FluidStack)object));
        }
        return null;
    }

    @Nullable
    public static IFluidIngredient checkedFluidIngredient(IFluidIngredient ingredient) {
        return ingredient == null || !ingredient.isValid() ? null : ingredient;
    }

    @Nullable
    public static IParticleIngredient buildParticleIngredient(Object object) {
        if (AbstractQMDRecipeHandler.requiresParticleFixing(object)) {
            object = QMDRecipeHelper.fixParticleStack(object);
        }
        if (object instanceof IParticleIngredient) {
            return QMDRecipeHelper.checkedParticleIngredient((IParticleIngredient)object);
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<IParticleIngredient> buildList = new ArrayList<IParticleIngredient>();
            if (!list.isEmpty()) {
                for (Object listObject : list) {
                    IParticleIngredient recipeObject;
                    if (listObject instanceof IParticleIngredient) {
                        buildList.add((IParticleIngredient)listObject);
                        continue;
                    }
                    if (listObject == null || (recipeObject = QMDRecipeHelper.checkedParticleIngredient(QMDRecipeHelper.buildParticleIngredient(listObject))) == null) continue;
                    buildList.add(recipeObject);
                }
                if (buildList.isEmpty()) {
                    return null;
                }
                return QMDRecipeHelper.checkedParticleIngredient(new ParticleArrayIngredient(buildList));
            }
            return null;
        }
        if (object instanceof String) {
            return QMDRecipeHelper.checkedParticleIngredient(QMDRecipeHelper.particleStackFromString((String)object));
        }
        if (object instanceof ParticleStack) {
            return QMDRecipeHelper.checkedParticleIngredient(new ParticleIngredient((ParticleStack)object));
        }
        return null;
    }

    @Nullable
    public static IParticleIngredient checkedParticleIngredient(IParticleIngredient ingredient) {
        return ingredient == null || !ingredient.isValid() ? null : ingredient;
    }

    public static boolean needsExpanding() {
        return ModCheck.mekanismLoaded() || ModCheck.techRebornLoaded();
    }

    public static List<FluidIngredient> expandedFluidStackList(FluidIngredient stack) {
        ArrayList fluidStackList = Lists.newArrayList((Object[])new FluidIngredient[]{stack});
        if (ModCheck.mekanismLoaded() && !stack.fluidName.equals("helium")) {
            if (GasHelper.TRANSLATION_MAP.containsKey((Object)stack.fluidName)) {
                fluidStackList.add(AbstractQMDRecipeHandler.fluidStack((String)GasHelper.TRANSLATION_MAP.get((Object)stack.fluidName), stack.stack.amount));
            } else {
                fluidStackList.add(AbstractQMDRecipeHandler.fluidStack("liquid" + stack.fluidName, stack.stack.amount));
            }
        }
        if (ModCheck.techRebornLoaded()) {
            fluidStackList.add(AbstractQMDRecipeHandler.fluidStack("fluid" + stack.fluidName, stack.stack.amount));
        }
        return fluidStackList;
    }

    public static QMDRecipeMatchResult matchIngredients(IngredientSorption sorption, List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients, List<IParticleIngredient> particleIngredients, List items, List fluids, List particles, boolean shapeless, List extras) {
        if (itemIngredients.size() != items.size() || fluidIngredients.size() != fluids.size() || particleIngredients.size() != particles.size()) {
            return QMDRecipeMatchResult.FAIL;
        }
        ArrayList<Integer> itemIngredientNumbers = new ArrayList<Integer>(Collections.nCopies(itemIngredients.size(), 0));
        ArrayList<Integer> fluidIngredientNumbers = new ArrayList<Integer>(Collections.nCopies(fluidIngredients.size(), 0));
        ArrayList<Integer> particleIngredientNumbers = new ArrayList<Integer>(Collections.nCopies(particleIngredients.size(), 0));
        IntList itemInputOrder = CollectionHelper.increasingList((int)itemIngredients.size());
        IntList fluidInputOrder = CollectionHelper.increasingList((int)fluidIngredients.size());
        IntList particleInputOrder = CollectionHelper.increasingList((int)particleIngredients.size());
        if (!shapeless) {
            IngredientMatchResult matchResult;
            int i;
            for (i = 0; i < items.size(); ++i) {
                matchResult = itemIngredients.get(i).match(items.get(i), sorption);
                if (!matchResult.matches()) {
                    return QMDRecipeMatchResult.FAIL;
                }
                itemIngredientNumbers.set(i, matchResult.getIngredientNumber());
            }
            for (i = 0; i < fluids.size(); ++i) {
                Object fluid = fluids.get(i) instanceof Tank ? ((Tank)fluids.get(i)).getFluid() : fluids.get(i);
                IngredientMatchResult matchResult2 = fluidIngredients.get(i).match(fluid, sorption);
                if (!matchResult2.matches()) {
                    return QMDRecipeMatchResult.FAIL;
                }
                fluidIngredientNumbers.set(i, matchResult2.getIngredientNumber());
            }
            for (i = 0; i < particles.size(); ++i) {
                matchResult = particleIngredients.get(i).matchWithData(particles.get(i), sorption, extras);
                if (!matchResult.matches()) {
                    return QMDRecipeMatchResult.FAIL;
                }
                particleIngredientNumbers.set(i, matchResult.getIngredientNumber());
            }
        } else {
            IngredientMatchResult matchResult;
            ArrayList<IItemIngredient> itemIngredientsRemaining = new ArrayList<IItemIngredient>(itemIngredients);
            for (int i = 0; i < items.size(); ++i) {
                IngredientMatchResult matchResult3;
                int j;
                block18: {
                    for (j = 0; j < itemIngredients.size(); ++j) {
                        IItemIngredient itemIngredient = (IItemIngredient)itemIngredientsRemaining.get(j);
                        if (itemIngredient == null || !(matchResult3 = itemIngredient.match(items.get(i), sorption)).matches()) {
                            continue;
                        }
                        break block18;
                    }
                    return QMDRecipeMatchResult.FAIL;
                }
                itemIngredientsRemaining.set(j, null);
                itemIngredientNumbers.set(i, matchResult3.getIngredientNumber());
                itemInputOrder.set(i, j);
            }
            ArrayList<IFluidIngredient> fluidIngredientsRemaining = new ArrayList<IFluidIngredient>(fluidIngredients);
            for (int i = 0; i < fluids.size(); ++i) {
                int j;
                block19: {
                    Object fluid = fluids.get(i) instanceof Tank ? ((Tank)fluids.get(i)).getFluid() : fluids.get(i);
                    for (j = 0; j < fluidIngredients.size(); ++j) {
                        IFluidIngredient fluidIngredient = (IFluidIngredient)fluidIngredientsRemaining.get(j);
                        if (fluidIngredient == null || !(matchResult = fluidIngredient.match(fluid, sorption)).matches()) {
                            continue;
                        }
                        break block19;
                    }
                    return QMDRecipeMatchResult.FAIL;
                }
                fluidIngredientsRemaining.set(j, null);
                fluidIngredientNumbers.set(i, matchResult.getIngredientNumber());
                fluidInputOrder.set(i, j);
            }
            ArrayList<IParticleIngredient> particleIngredientsRemaining = new ArrayList<IParticleIngredient>(particleIngredients);
            for (int i = 0; i < particles.size(); ++i) {
                int j;
                block20: {
                    for (j = 0; j < particleIngredients.size(); ++j) {
                        IParticleIngredient particleIngredient = (IParticleIngredient)particleIngredientsRemaining.get(j);
                        if (particleIngredient == null || !(matchResult = particleIngredient.matchWithData(particles.get(i), sorption, extras)).matches()) {
                            continue;
                        }
                        break block20;
                    }
                    return QMDRecipeMatchResult.FAIL;
                }
                particleIngredientsRemaining.set(j, null);
                particleIngredientNumbers.set(i, matchResult.getIngredientNumber());
                particleInputOrder.set(i, j);
            }
        }
        return new QMDRecipeMatchResult(true, itemIngredientNumbers, fluidIngredientNumbers, particleIngredientNumbers, (List<Integer>)itemInputOrder, (List<Integer>)fluidInputOrder, (List<Integer>)particleInputOrder);
    }

    public static List<String> getItemIngredientNames(List<IItemIngredient> ingredientList) {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (IItemIngredient ingredient : ingredientList) {
            if (ingredient == null || ingredient instanceof EmptyItemIngredient) {
                ingredientNames.add("null");
                continue;
            }
            if (ingredient instanceof ItemArrayIngredient) {
                ingredientNames.add(((ItemArrayIngredient)ingredient).getIngredientRecipeString());
                continue;
            }
            ingredientNames.add(ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName());
        }
        return ingredientNames;
    }

    public static List<String> getFluidIngredientNames(List<IFluidIngredient> ingredientList) {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (IFluidIngredient ingredient : ingredientList) {
            if (ingredient == null || ingredient instanceof EmptyFluidIngredient) {
                ingredientNames.add("null");
                continue;
            }
            if (ingredient instanceof FluidArrayIngredient) {
                ingredientNames.add(((FluidArrayIngredient)ingredient).getIngredientRecipeString());
                continue;
            }
            ingredientNames.add(ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName());
        }
        return ingredientNames;
    }

    public static List<String> getParticleIngredientNames(List<IParticleIngredient> ingredientList) {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (IParticleIngredient ingredient : ingredientList) {
            if (ingredient == null || ingredient instanceof EmptyParticleIngredient) {
                ingredientNames.add("null");
                continue;
            }
            if (ingredient instanceof ParticleArrayIngredient) {
                ingredientNames.add(((ParticleArrayIngredient)ingredient).getIngredientRecipeString());
                continue;
            }
            ingredientNames.add(ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName());
        }
        return ingredientNames;
    }

    public static String getAllIngredientNamesConcat(List<IItemIngredient> itemIngredientList, List<IFluidIngredient> fluidIngredientList, List<IParticleIngredient> particleIngredientList) {
        return StringHelper.stringListConcat(QMDRecipeHelper.getItemIngredientNames(itemIngredientList), (List[])new List[]{QMDRecipeHelper.getFluidIngredientNames(fluidIngredientList), QMDRecipeHelper.getParticleIngredientNames(particleIngredientList)});
    }

    public static String getRecipeString(List<IItemIngredient> itemIngredientList, List<IFluidIngredient> fluidIngredientList, List<IParticleIngredient> particleIngredientList, List<IItemIngredient> itemProductList, List<IFluidIngredient> fluidProductList, List<IParticleIngredient> particleProductList) {
        return QMDRecipeHelper.getAllIngredientNamesConcat(itemIngredientList, fluidIngredientList, particleIngredientList) + " -> " + QMDRecipeHelper.getAllIngredientNamesConcat(itemProductList, fluidProductList, particleProductList);
    }

    public static String getRecipeString(IQMDRecipe recipe) {
        if (recipe == null) {
            return "nullRecipe";
        }
        return QMDRecipeHelper.getRecipeString(recipe.getItemIngredients(), recipe.getFluidIngredients(), recipe.getParticleIngredients(), recipe.getItemProducts(), recipe.getFluidProducts(), recipe.getParticleProducts());
    }

    public static List<String> buildItemIngredientNames(List ingredientList) {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (Object obj : ingredientList) {
            IItemIngredient ingredient;
            if (obj == null) {
                ingredientNames.add("null");
                continue;
            }
            if (!(obj instanceof IItemIngredient)) {
                obj = QMDRecipeHelper.buildItemIngredient(obj);
            }
            if ((ingredient = (IItemIngredient)obj) instanceof ItemArrayIngredient) {
                ingredientNames.add(((ItemArrayIngredient)ingredient).getIngredientRecipeString());
                continue;
            }
            ingredientNames.add(ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName());
        }
        return ingredientNames;
    }

    public static List<String> buildFluidIngredientNames(List ingredientList) {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (Object obj : ingredientList) {
            IFluidIngredient ingredient;
            if (obj == null) {
                ingredientNames.add("null");
                continue;
            }
            if (!(obj instanceof IFluidIngredient)) {
                obj = QMDRecipeHelper.buildFluidIngredient(obj);
            }
            if ((ingredient = (IFluidIngredient)obj) instanceof FluidArrayIngredient) {
                ingredientNames.add(((FluidArrayIngredient)ingredient).getIngredientRecipeString());
                continue;
            }
            ingredientNames.add(ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName());
        }
        return ingredientNames;
    }

    public static List<List<String>> validFluids(QMDRecipeHandler recipes) {
        return QMDRecipeHelper.validFluids(recipes, new ArrayList<String>());
    }

    public static List<List<String>> validFluids(QMDRecipeHandler recipes, List<String> exceptions) {
        int i;
        int fluidInputSize = recipes.getFluidInputSize();
        int fluidOutputSize = recipes.getFluidOutputSize();
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (Object fluid : FluidRegistry.getRegisteredFluids().values()) {
            fluidStackList.add(new FluidStack((Fluid)fluid, 1000));
        }
        ArrayList<String> fluidNameList = new ArrayList<String>();
        for (FluidStack fluidStack : fluidStackList) {
            String fluidName = fluidStack.getFluid().getName();
            if (!recipes.isValidFluidInput(fluidStack) || exceptions.contains(fluidName)) continue;
            fluidNameList.add(fluidName);
        }
        ArrayList<List<String>> allowedFluidLists = new ArrayList<List<String>>();
        for (i = 0; i < fluidInputSize; ++i) {
            allowedFluidLists.add(fluidNameList);
        }
        for (i = fluidInputSize; i < fluidInputSize + fluidOutputSize; ++i) {
            allowedFluidLists.add(null);
        }
        return allowedFluidLists;
    }

    public static OreIngredient getOreStackFromItems(List<ItemStack> stackList, int stackSize) {
        if (stackList == null || stackList.isEmpty()) {
            return null;
        }
        String oreName = OreDictHelper.getOreNameFromStacks(stackList);
        if (oreName.equals("Unknown")) {
            return null;
        }
        return new OreIngredient(oreName, stackSize);
    }

    public static long hashMaterialsRaw(List<ItemStack> items, List<Tank> fluids, List<ParticleStack> particles) {
        long hash = 1L;
        for (ItemStack stack : items) {
            hash = 31L * hash + (stack == null ? 0L : (long)RecipeItemHelper.func_194113_b((ItemStack)stack));
        }
        for (Tank tank : fluids) {
            hash = 31L * hash + (tank == null ? 0L : (tank.getFluid() == null ? 0L : (long)tank.getFluid().getFluid().getName().hashCode()));
        }
        for (ParticleStack stack : particles) {
            hash = 31L * hash + (stack == null ? 0L : (long)stack.getParticle().getName().hashCode());
        }
        return hash;
    }

    public static long hashMaterials(List<ItemStack> items, List<FluidStack> fluids, List<ParticleStack> particles) {
        long hash = 1L;
        for (ItemStack stack : items) {
            hash = 31L * hash + (stack == null ? 0L : (long)RecipeItemHelper.func_194113_b((ItemStack)stack));
        }
        for (FluidStack stack : fluids) {
            hash = 31L * hash + (stack == null ? 0L : (long)stack.getFluid().getName().hashCode());
        }
        for (ParticleStack stack : particles) {
            hash = 31L * hash + (stack == null ? 0L : (long)stack.getParticle().getName().hashCode());
        }
        return hash;
    }

    public static InventoryCrafting fakeCrafter(int width, int height) {
        return new FakeCrafting(width, height);
    }

    private static class FakeCrafting
    extends InventoryCrafting {
        private static final FakeCraftingContainer FAKE_CONTAINER = new FakeCraftingContainer();

        private FakeCrafting(int width, int height) {
            super((Container)FAKE_CONTAINER, width, height);
        }

        private static class FakeCraftingContainer
        extends Container {
            private FakeCraftingContainer() {
            }

            public void func_75130_a(IInventory inventory) {
            }

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }
    }
}

