/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.tile;

import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.recipes.AtmosphereCollectorRecipes;
import nc.tile.generator.TileItemFluidGenerator;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.inventory.ItemSorption;
import nc.util.MaterialHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileAtmosphereCollector
extends TileItemFluidGenerator {
    private double efficiency = 0.0;

    public TileAtmosphereCollector() {
        super("atmosphere_collector", 0, 0, 0, 1, 0, TileAtmosphereCollector.defaultItemSorptions((int)0, (int)0, (ItemSorption[])new ItemSorption[0]), TileAtmosphereCollector.defaultTankCapacities((int)32000, (int)0, (int)1), TileAtmosphereCollector.defaultTankSorptions((int)0, (int)1), null, QMDConfig.processor_power[1] * 20, null);
        this.setEnergyConnectionAll(EnergyConnection.IN);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.time += 1.0;
            if (this.time >= 100.0) {
                this.checkEfficency();
                this.time = 0.0;
            }
            boolean wasProcessing = this.isProcessing;
            boolean shouldUpdate = false;
            this.isProcessing = this.isProcessing();
            if (this.isProcessing) {
                this.process();
            }
            if (wasProcessing != this.isProcessing) {
                shouldUpdate = true;
            }
            if (shouldUpdate) {
                this.func_70296_d();
            }
            this.pushFluid();
        }
    }

    public boolean setRecipeStats() {
        return true;
    }

    public void refreshRecipe() {
    }

    public void refreshActivity() {
    }

    public boolean isProcessing() {
        return this.readyToProcess();
    }

    public boolean readyToProcess() {
        return this.hasSufficientEnergy();
    }

    public boolean hasSufficientEnergy() {
        return this.getEnergyStored() >= QMDConfig.processor_power[1];
    }

    public void process() {
        FluidStack fluidStack = AtmosphereCollectorRecipes.getRecipe(this.field_145850_b.field_73011_w.getDimension());
        if (fluidStack != null && !((Tank)this.getTanks().get(0)).isFull()) {
            this.getEnergyStorage().changeEnergyStored((long)(-QMDConfig.processor_power[1]));
            if (((Tank)this.getTanks().get(0)).isEmpty()) {
                ((Tank)this.getTanks().get(0)).changeFluidStored(fluidStack.getFluid(), (int)((double)fluidStack.amount * this.efficiency));
            } else if (((Tank)this.getTanks().get(0)).getFluid().isFluidEqual(fluidStack)) {
                ((Tank)this.getTanks().get(0)).changeFluidAmount((int)((double)fluidStack.amount * this.efficiency));
            }
        }
    }

    public void checkEfficency() {
        Iterable checkArea = BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-2, -2, -2), (BlockPos)this.field_174879_c.func_177982_a(2, 2, 2));
        int occlusiveBlocks = 0;
        int checkedBlocks = 0;
        for (BlockPos otherPos : checkArea) {
            ++checkedBlocks;
            IBlockState state = this.field_145850_b.func_180495_p(otherPos);
            if (MaterialHelper.isEmpty((Material)state.func_185904_a()) || !state.func_185914_p() && state.func_185904_a().func_76218_k()) continue;
            ++occlusiveBlocks;
        }
        this.efficiency = 1.0 - (double)(occlusiveBlocks - 1) / (double)(checkedBlocks - 1);
    }

    public int getCollectionRate() {
        FluidStack fluidStack;
        if (this.isProcessing() && (fluidStack = AtmosphereCollectorRecipes.getRecipe(this.field_145850_b.field_73011_w.getDimension())) != null) {
            return (int)((double)fluidStack.amount * this.efficiency);
        }
        return 0;
    }

    public Fluid getCollectionFluid() {
        FluidStack fluidStack;
        if (this.isProcessing() && (fluidStack = AtmosphereCollectorRecipes.getRecipe(this.field_145850_b.field_73011_w.getDimension())) != null) {
            return fluidStack.getFluid();
        }
        return null;
    }

    public int getSinkTier() {
        return 10;
    }

    public int getSourceTier() {
        return 1;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("efficiency", this.efficiency);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.efficiency = nbt.func_74769_h("efficiency");
    }
}

