/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.activetime.commands;

import com.google.common.collect.ImmutableMap;
import com.mcsimonflash.sponge.activetime.ActiveTime;
import com.mcsimonflash.sponge.activetime.commands.Check;
import com.mcsimonflash.sponge.activetime.commands.Leaderboard;
import com.mcsimonflash.sponge.activetime.commands.Report;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;

public class Base
implements CommandExecutor {
    public static final CommandSpec SPEC = CommandSpec.builder().executor((CommandExecutor)new Base()).child((CommandCallable)Check.SPEC, new String[]{"check", "info", "time"}).child((CommandCallable)Leaderboard.SPEC, new String[]{"leaderboard", "rank", "top"}).child((CommandCallable)Report.SPEC, new String[]{"report"}).description((Text)Text.of((String)"Opens the in-game documentation")).permission("activetime.base").build();
    private static final ImmutableMap<String, Text> USAGES = ImmutableMap.builder().put((Object)"activetime.base", (Object)Base.usage("/activetime ", new Text[0])).put((Object)"activetime.check.base", (Object)Base.usage("/activetime check ", Base.arg(false, "user", "Name of the user to check"))).put((Object)"activetime.leaderboard.base", (Object)Base.usage("/activetime leaderboard ", Base.arg(false, "positions", "Number of positions to include"))).put((Object)"activetime.report.base", (Object)Base.usage("/activetime report ", Base.arg(false, "-server", "Generate a report for the server"), Base.arg(false, "-user", "Generate a report for a user"), Base.arg(false, "-from", "The date to start the report"), Base.arg(false, "-to", "The date to end the report"))).build();
    private static final Text LINKS = Text.of((Object[])new Object[]{"                      ", TextColors.GRAY, Base.link("Ore Project", Optional.ofNullable(ActiveTime.getOre())), TextColors.GRAY, " | ", Base.link("Support Discord", Optional.ofNullable(ActiveTime.getDiscord()))});

    public CommandResult execute(CommandSource src, CommandContext args) {
        (src instanceof Player ? PaginationList.builder() : PaginationList.builder().linesPerPage(-1)).padding(Text.of((Object[])new Object[]{TextColors.AQUA, "="})).title((Text)Text.of((String)"ActiveTime")).contents((Iterable)USAGES.entrySet().stream().filter(e -> src.hasPermission((String)e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList())).footer(LINKS).build().sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private static Text usage(String base, Text ... args) {
        return Text.builder((String)base).color(TextColors.WHITE).onClick((ClickAction)TextActions.suggestCommand((String)base)).append(new Text[]{Text.joinWith((Text)Text.of((String)" "), (Text[])args)}).build();
    }

    private static Text arg(boolean req, String name, String desc) {
        return Text.builder((String)((req ? "<" : "[") + name + (req ? ">" : "]"))).color(TextColors.AQUA).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.WHITE, name, ": ", TextColors.GRAY, desc}))).build();
    }

    private static Text link(String name, Optional<URL> optUrl) {
        return (Text)optUrl.map(u -> Text.builder((String)name).style(new TextStyle[]{TextStyles.UNDERLINE}).onClick((ClickAction)TextActions.openUrl((URL)u)).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{u}))).build()).orElse(Text.builder((String)name).color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.RED, "Sorry! This URL is unavailable."}))).build());
    }
}

