/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.activetime.commands;

import com.mcsimonflash.sponge.activetime.managers.Config;
import com.mcsimonflash.sponge.activetime.managers.Storage;
import com.mcsimonflash.sponge.activetime.managers.Util;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.text.Text;

public class Leaderboard
implements CommandExecutor {
    public static final CommandSpec SPEC = CommandSpec.builder().executor((CommandExecutor)new Leaderboard()).arguments(GenericArguments.optional((CommandElement)GenericArguments.integer((Text)Text.of((String)"positions")))).description((Text)Text.of((String)"Displays the leaderboard of active players")).permission("activetime.leaderboard.base").build();

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Integer positions = args.getOne("positions").orElse(Config.defaultPos);
        if (positions <= 0 || positions > Config.maximumPos) {
            throw new CommandException(Util.toText("&fRange must be within &b1 &fand &b" + Config.maximumPos + "&f."));
        }
        Util.sendPagination(src, "ActiveTime Leaderboard", Storage.leaderboard.stream().limit(positions.intValue()).collect(Collectors.toList()));
        return CommandResult.success();
    }
}

