/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.network;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.content.blocks.launcher.network.LauncherNetwork;
import icbm.classic.content.blocks.launcher.network.LauncherNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class NetworkEnergyStorage
implements IEnergyStorage {
    private final LauncherNetwork network;

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int actualReceived = 0;
        int launcherCount = 0;
        List nodes = this.powerNodes().collect(Collectors.toList());
        for (IEnergyStorage storage : nodes) {
            int launchersLeft = nodes.size() - launcherCount++;
            int energyLeft = maxReceive - actualReceived;
            int energyToGive = Math.min(energyLeft, (int)Math.floor((float)energyLeft / (float)launchersLeft) + 1);
            actualReceived += storage.receiveEnergy(energyToGive, simulate);
        }
        return actualReceived;
    }

    private Stream<IEnergyStorage> powerNodes() {
        return this.network.getComponents().stream().map(LauncherNode::getSelf).filter(tile -> tile.hasCapability(CapabilityEnergy.ENERGY, null)).filter(tile -> tile.hasCapability(ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY, null)).map(tile -> (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, null)).filter(Objects::nonNull);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.powerNodes().mapToInt(IEnergyStorage::getEnergyStored).sum();
    }

    public int getMaxEnergyStored() {
        return this.powerNodes().mapToInt(IEnergyStorage::getMaxEnergyStored).sum();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public NetworkEnergyStorage(LauncherNetwork network) {
        this.network = network;
    }
}

