/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.explosion.IBlast;
import icbm.classic.api.explosion.IBlastFactory;
import icbm.classic.api.explosion.IBlastInit;
import icbm.classic.api.explosion.IBlastMovable;
import icbm.classic.api.explosion.IBlastRestore;
import icbm.classic.api.explosion.IBlastTickable;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.config.ConfigDebug;
import icbm.classic.content.blast.Blast;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

@Deprecated
public class EntityExplosion
extends Entity
implements IEntityAdditionalSpawnData {
    private IBlast blast;
    private double blastYOffset = 0.0;

    public EntityExplosion(World world) {
        super(world);
        this.field_70156_m = true;
        this.field_70145_X = true;
        this.func_70105_a(0.98f, 0.98f);
        this.field_70158_ak = true;
        this.field_70173_aa = 0;
    }

    public EntityExplosion(Blast blast) {
        this(blast.world());
        this.setBlast(blast);
        if (ConfigDebug.DEBUG_EXPLOSIVES) {
            ICBMClassic.logger().info("EntityExplosion#new(" + blast + ") Created new blast controller entity");
        }
    }

    public String func_70005_c_() {
        return "Explosion[" + this.blast + "]";
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.blast.getExplosiveData().getRegistryName().toString());
        data.writeDouble(this.blastYOffset);
    }

    public void readSpawnData(ByteBuf data) {
        this.constructBlast(ByteBufUtils.readUTF8String((ByteBuf)data), data.readDouble());
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70071_h_() {
        if (this.getBlast() == null || this.getBlast().getEntity() != this || this.getBlast().isCompleted()) {
            this.func_70106_y();
            return;
        }
        if (this.getBlast() instanceof IBlastMovable && (this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0)) {
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
            float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70159_w /= (double)speed;
            this.field_70181_x /= (double)speed;
            this.field_70179_y /= (double)speed;
            speed = Math.min(speed, 0.5f);
            this.field_70159_w *= (double)speed;
            this.field_70181_x *= (double)speed;
            this.field_70179_y *= (double)speed;
            this.func_174826_a(this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y));
            this.field_70165_t = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
            this.field_70163_u = (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0;
            this.field_70161_v = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
            ((IBlastMovable)this.getBlast()).onPositionUpdate(this.field_70165_t, this.field_70163_u + this.blastYOffset, this.field_70161_v);
        }
        if (this.blast instanceof IBlastTickable && ((IBlastTickable)this.blast).onBlastTick(this.field_70173_aa)) {
            this.func_70106_y();
        }
    }

    public void func_70091_d(MoverType type, double p_70091_1_, double p_70091_3_, double p_70091_5_) {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        try {
            NBTTagCompound blastSave = nbt.func_74775_l("blast");
            this.blastYOffset = nbt.func_74769_h("blastPosY");
            if (this.getBlast() == null) {
                if (blastSave.func_74764_b("class")) {
                    Class<?> clazz = Class.forName(blastSave.func_74779_i("class"));
                    Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                    Blast blast = (Blast)constructor.newInstance(new Object[0]);
                    blast.setBlastWorld(this.field_70170_p);
                    blast.setPosition(this.field_70165_t, this.field_70163_u + this.blastYOffset, this.field_70161_v);
                    blast.setEntityController(this);
                    blast.buildBlast();
                } else if (blastSave.func_74764_b("ex_id")) {
                    this.constructBlast(blastSave.func_74779_i("ex_id"), this.blastYOffset);
                } else {
                    ICBMClassic.logger().error("EntityExplosion: Failed to read save state for explosion!");
                }
            }
            if (this.getBlast() instanceof IBlastRestore) {
                ((IBlastRestore)this.getBlast()).load(blastSave);
            }
        }
        catch (Exception e) {
            ICBMClassic.logger().error("EntityExplosion: Unexpected error restoring save state of explosion entity!", (Throwable)e);
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.getBlast() != null && this.getBlast().getExplosiveData() != null) {
            nbt.func_74780_a("blastPosY", this.blastYOffset);
            NBTTagCompound blastSave = new NBTTagCompound();
            if (this.getBlast() instanceof IBlastRestore) {
                ((IBlastRestore)this.getBlast()).save(blastSave);
            }
            blastSave.func_74778_a("ex_id", this.getBlast().getExplosiveData().getRegistryName().toString());
            nbt.func_74782_a("blast", (NBTBase)blastSave);
        }
    }

    public IBlast getBlast() {
        return this.blast;
    }

    public void setBlast(Blast blast) {
        this.blast = blast;
        if (blast != null) {
            if (blast instanceof IBlastInit) {
                ((Blast)this.blast).setEntityController(this);
            }
            this.func_70107_b(blast.location.x(), !blast.isMovable() ? -1.0 : blast.y(), blast.location.z());
            this.blastYOffset = blast.isMovable() ? 0.0 : blast.y() + 1.0;
        }
    }

    private void constructBlast(String exId, double yOffset) {
        IBlastFactory factory;
        ResourceLocation id = new ResourceLocation(exId);
        IExplosiveData exData = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(id);
        if (exData != null && (factory = exData.getBlastFactory()) != null) {
            this.blast = factory.create();
            ((IBlastInit)this.blast).setBlastWorld(this.field_70170_p);
            ((IBlastInit)this.blast).setBlastPosition(this.field_70165_t, this.field_70163_u + yOffset, this.field_70161_v);
            ((IBlastInit)this.blast).setEntityController(this);
            ((IBlastInit)this.blast).setExplosiveData(exData);
            ((IBlastInit)this.blast).buildBlast();
            return;
        }
        ICBMClassic.logger().error("EntityExplosion: Failed to locate explosive with id '" + id + "'!");
    }
}

