/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.events.MissileRideEvent;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.content.missile.entity.explosive.EntityExplosiveMissile;
import icbm.classic.content.missile.logic.flight.BallisticFlightLogic;
import icbm.classic.content.missile.tracker.MissileTrackerHandler;
import icbm.classic.lib.radar.RadarMap;
import icbm.classic.lib.radar.RadarRegistry;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="icbmclassic")
public class MissileEventHandler {
    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        IMissile missile;
        if (event.isDismounting() && event.getEntityBeingMounted().hasCapability(ICBMClassicAPI.MISSILE_CAPABILITY, null) && event.getEntityMounting() instanceof EntityPlayer && (missile = (IMissile)event.getEntityBeingMounted().getCapability(ICBMClassicAPI.MISSILE_CAPABILITY, null)) != null) {
            event.setCanceled(MinecraftForge.EVENT_BUS.post((Event)new MissileRideEvent.Stop(missile, (EntityPlayer)event.getEntityMounting())));
        }
    }

    @SubscribeEvent
    public static void chunkUnload(ChunkEvent.Unload event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            Chunk chunk = event.getChunk();
            RadarMap map = RadarRegistry.getRadarMapForWorld(world);
            if (map != null) {
                LinkedList unloading = new LinkedList();
                map.collectEntitiesInChunk(chunk.field_76635_g, chunk.field_76647_h, radarEntity -> {
                    if (radarEntity.entity instanceof EntityExplosiveMissile) {
                        unloading.add((EntityExplosiveMissile)radarEntity.entity);
                    }
                });
                unloading.stream().filter(missile -> missile.getMissileCapability().getFlightLogic() instanceof BallisticFlightLogic).forEach(MissileTrackerHandler::simulateMissile);
            }
        }
    }
}

