/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.capability.ex;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.reg.IExplosiveData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityExplosive
implements IExplosive,
ICapabilitySerializable<NBTTagCompound> {
    public int explosiveID;
    public NBTTagCompound blastNBT;

    public CapabilityExplosive() {
    }

    public CapabilityExplosive(int id) {
        this.explosiveID = id;
    }

    @Override
    @Nullable
    public IExplosiveData getExplosiveData() {
        return ICBMClassicHelpers.getExplosive(this.explosiveID, false);
    }

    @Override
    @Nonnull
    public NBTTagCompound getCustomBlastData() {
        if (this.blastNBT == null) {
            this.blastNBT = new NBTTagCompound();
        }
        return this.blastNBT;
    }

    public void setCustomData(NBTTagCompound data) {
        this.blastNBT = data;
    }

    @Override
    @Nullable
    public ItemStack toStack() {
        return null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY) {
            return (T)this;
        }
        return null;
    }

    public final NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.serializeNBT(tagCompound);
        tagCompound.func_74768_a("explosiveID", this.explosiveID);
        tagCompound.func_74782_a("blastData", (NBTBase)this.getCustomBlastData());
        return tagCompound;
    }

    protected void serializeNBT(NBTTagCompound tag) {
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("explosiveID")) {
            this.explosiveID = nbt.func_74762_e("explosiveID");
        }
        if (this.blastNBT == null || nbt.func_74764_b("blastData")) {
            this.blastNBT = nbt.func_74775_l("blastData");
        }
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IExplosive.class, (Capability.IStorage)new Capability.IStorage<IExplosive>(){

            @Nullable
            public NBTBase writeNBT(Capability<IExplosive> capability, IExplosive instance, EnumFacing side) {
                if (instance instanceof CapabilityExplosive) {
                    return ((CapabilityExplosive)instance).serializeNBT();
                }
                return null;
            }

            public void readNBT(Capability<IExplosive> capability, IExplosive instance, EnumFacing side, NBTBase nbt) {
                if (instance instanceof CapabilityExplosive && nbt instanceof NBTTagCompound) {
                    ((CapabilityExplosive)instance).deserializeNBT((NBTTagCompound)nbt);
                }
            }
        }, () -> new CapabilityExplosive(-1));
    }
}

