/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.network.packet;

import icbm.classic.ICBMClassic;
import icbm.classic.lib.network.IPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSpawnBlockExplosion
implements IPacket<PacketSpawnBlockExplosion> {
    private int dimId;
    private double sourceX;
    private double sourceY;
    private double sourceZ;
    private double blastScale;
    private BlockPos blockPos;

    public PacketSpawnBlockExplosion() {
    }

    public PacketSpawnBlockExplosion(int dimId, double sourceX, double sourceY, double sourceZ, double blastScale, BlockPos pos) {
        this.dimId = dimId;
        this.sourceX = sourceX;
        this.sourceY = sourceY;
        this.sourceZ = sourceZ;
        this.blockPos = pos;
        this.blastScale = blastScale;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dimId);
        buffer.writeDouble(this.sourceX);
        buffer.writeDouble(this.sourceY);
        buffer.writeDouble(this.sourceZ);
        buffer.writeDouble(this.blastScale);
        buffer.writeInt(this.blockPos.func_177958_n());
        buffer.writeInt(this.blockPos.func_177956_o());
        buffer.writeInt(this.blockPos.func_177952_p());
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dimId = buffer.readInt();
        this.sourceX = buffer.readDouble();
        this.sourceY = buffer.readDouble();
        this.sourceZ = buffer.readDouble();
        this.blastScale = buffer.readDouble();
        this.blockPos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        if (Minecraft.func_71410_x().field_71441_e != null && player.field_70170_p.field_73011_w.getDimension() == this.dimId) {
            ICBMClassic.proxy.spawnExplosionParticles(player.field_70170_p, this.sourceX, this.sourceY, this.sourceZ, this.blastScale, this.blockPos);
        }
    }

    public static void sendToAllClients(World world, double sourceX, double sourceY, double sourceZ, double blastScale, BlockPos pos) {
        int dimid = world.field_73011_w.getDimension();
        PacketSpawnBlockExplosion packet = new PacketSpawnBlockExplosion(dimid, sourceX, sourceY, sourceZ, blastScale, pos);
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(dimid, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 256.0);
        ICBMClassic.packetHandler.sendToAllAround((IPacket)packet, point);
    }
}

