/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.radio.messages;

import icbm.classic.api.radio.messages.ITextMessage;
import java.util.Arrays;

public class TextMessage
implements ITextMessage {
    private final String channel;
    private final String message;
    private final boolean shouldTranslate;
    private final Object[] translationInputs;

    public TextMessage(String channel, String message) {
        this.channel = channel;
        this.message = message;
        this.shouldTranslate = true;
        this.translationInputs = null;
    }

    public TextMessage(String channel, String message, Object ... data) {
        this.channel = channel;
        this.message = message;
        this.shouldTranslate = true;
        this.translationInputs = data;
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean shouldTranslate() {
        return this.shouldTranslate;
    }

    @Override
    public Object[] getTranslationInputs() {
        return this.translationInputs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextMessage)) {
            return false;
        }
        TextMessage other = (TextMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.shouldTranslate() != other.shouldTranslate()) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        return Arrays.deepEquals(this.getTranslationInputs(), other.getTranslationInputs());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.shouldTranslate() ? 79 : 97);
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTranslationInputs());
        return result;
    }

    public String toString() {
        return "TextMessage(channel=" + this.getChannel() + ", message=" + this.getMessage() + ", shouldTranslate=" + this.shouldTranslate() + ", translationInputs=" + Arrays.deepToString(this.getTranslationInputs()) + ")";
    }

    public TextMessage(String channel, String message, boolean shouldTranslate, Object[] translationInputs) {
        this.channel = channel;
        this.message = message;
        this.shouldTranslate = shouldTranslate;
        this.translationInputs = translationInputs;
    }
}

