/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdscheduler.command.create;

import com.google.inject.Inject;
import com.mcsimonflash.sponge.cmdcontrol.core.CmdUtils;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.Arguments;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Aliases;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Command;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Permission;
import com.mcsimonflash.sponge.cmdscheduler.command.create.Create;
import com.mcsimonflash.sponge.cmdscheduler.schedule.CalendarSchedule;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

@Aliases(value={"calendar"})
@Permission(value="cmdscheduler.command.create.calendar.base")
public class Calendar
extends Command {
    @Inject
    private Calendar(Command.Settings settings) {
        super(settings.usage(CmdUtils.usage((String)"/cmdscheduler create calendar ", (Text)CmdUtils.info((String)"Calendar", (String)"Create a new task with a calendar schedule.\n", (String)"", (String)"calendar\n", (String)"cmdscheduler.command.create.calendar.base"), (Text[])new Text[]{Create.NAME_ARG, CmdUtils.arg((boolean)false, (String)"-date", (Text)CmdUtils.info((String)"Date", (String)"The calendar date to execute this task on.\n", (String)"Date (in the form yyyy-MM-dd/HH:mm:ss.SSS)\n", (String)"-date, -d", (String)"")), CmdUtils.arg((boolean)false, (String)"-interval", (Text)CmdUtils.info((String)"Interval", (String)"The interval of this task.\n", (String)"Duration (in the form #d#h#m#s#ms)\n", (String)"-interval, -i", (String)"")), Create.ASYNC_FLAG, Create.START_FLAG, Create.COMMAND_ARG})).elements(new CommandElement[]{Arguments.string().toElement("name"), Arguments.flags().flag(new String[]{"start"}).flag((CommandElement)Arguments.tristate().toElement("async"), new String[]{"async", "a"}).flag((CommandElement)Arguments.string().toElement("date"), new String[]{"date", "d"}).flag((CommandElement)Arguments.duration().toElement("interval"), new String[]{"interval", "i"}).build(), Arguments.command().toElement("command")}));
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        return Create.create(src, args, Calendar::apply);
    }

    private static CalendarSchedule apply(CommandContext args) {
        CalendarSchedule.Builder builder = CalendarSchedule.builder();
        args.getOne("date").ifPresent(builder::date);
        args.getOne("interval").ifPresent(builder::interval);
        return builder.build();
    }
}

