/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe;

import buildcraft.api.core.EnumHandlerPriority;
import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandlerBlock;
import buildcraft.api.transport.IStripesHandlerItem;
import buildcraft.api.transport.IStripesRegistry;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum StripesRegistry implements IStripesRegistry
{
    INSTANCE;

    private final EnumMap<EnumHandlerPriority, List<IStripesHandlerItem>> itemHandlers = new EnumMap(EnumHandlerPriority.class);
    private final EnumMap<EnumHandlerPriority, List<IStripesHandlerBlock>> blockHandlers = new EnumMap(EnumHandlerPriority.class);

    private StripesRegistry() {
        for (EnumHandlerPriority priority : EnumHandlerPriority.VALUES) {
            this.itemHandlers.put(priority, new ArrayList());
            this.blockHandlers.put(priority, new ArrayList());
        }
    }

    @Override
    public void addHandler(IStripesHandlerItem handler, EnumHandlerPriority priority) {
        this.itemHandlers.get(priority).add(handler);
    }

    @Override
    public void addHandler(IStripesHandlerBlock handler, EnumHandlerPriority priority) {
        this.blockHandlers.get(priority).add(handler);
    }

    @Override
    public boolean handleItem(World world, BlockPos pos, EnumFacing direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        for (EnumHandlerPriority priority : EnumHandlerPriority.VALUES) {
            for (IStripesHandlerItem handler : this.itemHandlers.get(priority)) {
                if (!handler.handle(world, pos, direction, stack, player, activator)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean handleBlock(World world, BlockPos pos, EnumFacing direction, EntityPlayer player, IStripesActivator activator) {
        for (EnumHandlerPriority priority : EnumHandlerPriority.VALUES) {
            for (IStripesHandlerBlock handler : this.blockHandlers.get(priority)) {
                if (!handler.handle(world, pos, direction, player, activator)) continue;
                return true;
            }
        }
        return false;
    }
}

