/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjRedstoneReceiver;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeEventActionActivate;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventItem;
import buildcraft.api.transport.pipe.PipeEventStatement;
import buildcraft.api.transport.pipe.PipeFlow;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.StackUtil;
import buildcraft.transport.BCTransportStatements;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PipeBehaviourStripes
extends PipeBehaviour
implements IStripesActivator,
IMjRedstoneReceiver {
    private final MjBattery battery = new MjBattery(256L * MjAPI.MJ);
    @Nullable
    public EnumFacing direction = null;
    private int progress;

    public PipeBehaviourStripes(IPipe pipe) {
        super(pipe);
    }

    public PipeBehaviourStripes(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.battery.deserializeNBT(nbt.func_74775_l("battery"));
        this.setDirection(NBTUtilBC.readEnum(nbt.func_74781_a("direction"), EnumFacing.class));
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74782_a("battery", (NBTBase)this.battery.serializeNBT());
        nbt.func_74782_a("direction", NBTUtilBC.writeEnum(this.direction));
        return nbt;
    }

    @Override
    public void readPayload(PacketBuffer buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(buffer, side, ctx);
        this.direction = MessageUtil.readEnumOrNull((ByteBuf)buffer, EnumFacing.class);
    }

    @Override
    public void writePayload(PacketBuffer buffer, Side side) {
        super.writePayload(buffer, side);
        MessageUtil.writeEnumOrNull((ByteBuf)buffer, this.direction);
    }

    private void setDirection(@Nullable EnumFacing newValue) {
        if (this.direction != newValue) {
            this.direction = newValue;
            if (!this.pipe.getHolder().getPipeWorld().field_72995_K) {
                this.pipe.getHolder().scheduleNetworkUpdate(IPipeHolder.PipeMessageReceiver.BEHAVIOUR);
            }
        }
    }

    @PipeEventHandler
    public void addInternalActions(PipeEventStatement.AddActionInternal event) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            PipePluggable plug;
            if (this.pipe.isConnected(face) || (plug = this.pipe.getHolder().getPluggable(face)) != null && plug.isBlocking()) continue;
            event.actions.add(BCTransportStatements.ACTION_PIPE_DIRECTION[face.ordinal()]);
        }
    }

    @PipeEventHandler
    public void onActionActivate(PipeEventActionActivate event) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (event.action != BCTransportStatements.ACTION_PIPE_DIRECTION[face.ordinal()]) continue;
            this.setDirection(face);
        }
    }

    @Override
    public boolean canConnect(@Nonnull IMjConnector other) {
        return true;
    }

    @Override
    public long getPowerRequested() {
        return this.battery.getCapacity() - this.battery.getStored();
    }

    @Override
    public long receivePower(long microJoules, boolean simulate) {
        return this.battery.addPowerChecking(microJoules, simulate);
    }

    @Override
    public boolean canConnect(EnumFacing face, PipeBehaviour other) {
        return !(other instanceof PipeBehaviourStripes);
    }

    @Override
    public void onTick() {
        World world = this.pipe.getHolder().getPipeWorld();
        BlockPos pos = this.pipe.getHolder().getPipePos();
        if (world.field_72995_K) {
            return;
        }
        if (this.direction == null || this.pipe.isConnected(this.direction)) {
            int sides = 0;
            EnumFacing dir = null;
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (!this.pipe.isConnected(face)) continue;
                ++sides;
                dir = face;
            }
            if (sides == 1) {
                this.setDirection(dir.func_176734_d());
            } else {
                this.setDirection(null);
            }
        }
        this.battery.tick(world, this.pipe.getHolder().getPipePos());
        if (this.direction != null) {
            BlockPos offset = pos.func_177972_a(this.direction);
            long target = BlockUtil.computeBlockBreakPower(world, offset);
            if (target > 0L) {
                int offsetHash = offset.hashCode();
                if ((long)this.progress < target) {
                    this.progress = (int)((long)this.progress + this.battery.extractPower(0L, Math.min(target - (long)this.progress, MjAPI.MJ * 10L)));
                    if (this.progress > 0) {
                        world.func_175715_c(offsetHash, offset, (int)((long)(this.progress * 9) / target));
                    }
                } else {
                    BlockUtil.breakBlockAndGetDrops((WorldServer)world, offset, new ItemStack(Items.field_151046_w), this.pipe.getHolder().getOwner()).ifPresent(stacks -> stacks.forEach(stack -> this.sendItem((ItemStack)stack, this.direction)));
                    this.progress = 0;
                }
            }
        } else {
            this.progress = 0;
        }
    }

    @PipeEventHandler
    public void onDrop(PipeEventItem.Drop event) {
        if (this.direction == null) {
            return;
        }
        IPipeHolder holder = this.pipe.getHolder();
        World world = holder.getPipeWorld();
        BlockPos pos = holder.getPipePos();
        FakePlayer player = BuildCraftAPI.fakePlayerProvider.getFakePlayer((WorldServer)world, holder.getOwner(), pos);
        player.field_71071_by.func_174888_l();
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, event.getStack());
        if (PipeApi.stripeRegistry.handleItem(world, pos, this.direction, event.getStack(), (EntityPlayer)player, this)) {
            event.setStack(StackUtil.EMPTY);
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70304_b(i);
                if (stack.func_190926_b()) continue;
                this.sendItem(stack, this.direction);
            }
        }
    }

    @Override
    public void dropItem(@Nonnull ItemStack stack, EnumFacing direction) {
        InventoryUtil.drop(this.pipe.getHolder().getPipeWorld(), this.pipe.getHolder().getPipePos(), stack);
    }

    @Override
    public boolean sendItem(@Nonnull ItemStack stack, EnumFacing from) {
        PipeFlow flow = this.pipe.getFlow();
        if (flow instanceof IFlowItems) {
            ((IFlowItems)((Object)flow)).insertItemsForce(stack, from, null, 0.02);
            return true;
        }
        return false;
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == MjAPI.CAP_REDSTONE_RECEIVER) {
            return (T)MjAPI.CAP_REDSTONE_RECEIVER.cast((Object)this);
        }
        if (capability == MjAPI.CAP_RECEIVER) {
            return (T)MjAPI.CAP_RECEIVER.cast((Object)this);
        }
        if (capability == MjAPI.CAP_CONNECTOR) {
            return (T)MjAPI.CAP_CONNECTOR.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

