/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.traits;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;

public abstract class TraitProgressiveStats
extends AbstractTrait {
    protected final String pool_key;
    protected final String applied_key;

    public TraitProgressiveStats(String identifier, TextFormatting color) {
        super(identifier, color);
        this.pool_key = identifier + "StatPool";
        this.applied_key = identifier + "StatBonus";
    }

    protected static StatNBT getStats(NBTTagCompound root, String key) {
        return (StatNBT)ModifierNBT.readTag((NBTTagCompound)TagUtil.getTagSafe((NBTTagCompound)TagUtil.getExtraTag((NBTTagCompound)root), (String)key), StatNBT.class);
    }

    protected static void setStats(NBTTagCompound root, StatNBT data, String key) {
        NBTTagCompound extra = TagUtil.getExtraTag((NBTTagCompound)root);
        NBTTagCompound tag = new NBTTagCompound();
        data.write(tag);
        extra.func_74782_a(key, (NBTBase)tag);
        TagUtil.setExtraTag((NBTTagCompound)root, (NBTTagCompound)extra);
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        ToolNBT data = TagUtil.getToolStats((NBTTagCompound)rootCompound);
        StatNBT bonus = this.getBonus(rootCompound);
        data.durability += bonus.durability;
        data.speed += bonus.speed;
        data.attack += bonus.attack;
        TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)data.get());
    }

    protected boolean hasPool(NBTTagCompound root) {
        return TagUtil.getExtraTag((NBTTagCompound)root).func_74764_b(this.pool_key);
    }

    protected StatNBT getPool(NBTTagCompound root) {
        return TraitProgressiveStats.getStats(root, this.pool_key);
    }

    protected void setPool(NBTTagCompound root, StatNBT data) {
        TraitProgressiveStats.setStats(root, data, this.pool_key);
    }

    protected StatNBT getBonus(NBTTagCompound root) {
        return TraitProgressiveStats.getStats(root, this.applied_key);
    }

    protected void setBonus(NBTTagCompound root, StatNBT data) {
        TraitProgressiveStats.setStats(root, data, this.applied_key);
    }

    protected boolean playerIsBreakingBlock(Entity entity) {
        return false;
    }

    public static class StatNBT
    extends ModifierNBT {
        public int durability;
        public float attack;
        public float speed;

        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.durability = tag.func_74762_e("durability");
            this.attack = tag.func_74760_g("attack");
            this.speed = tag.func_74760_g("speed");
        }

        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74768_a("durability", this.durability);
            tag.func_74776_a("attack", this.attack);
            tag.func_74776_a("speed", this.speed);
        }
    }
}

