/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.args;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

public class FactionArgument
extends CommandElement {
    private final EagleFactions plugin;

    public FactionArgument(EagleFactions plugin, @Nullable Text key) {
        super(key);
        this.plugin = plugin;
    }

    @Nullable
    protected Faction parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        if (!args.hasNext()) {
            throw args.createError((Text)Text.of((String)"Argument is not a valid faction!"));
        }
        String factionName = args.next();
        Faction faction = this.plugin.getFactionLogic().getFactionByName(factionName);
        if (faction == null) {
            throw args.createError((Text)Text.of((String)"Argument is not a valid faction!"));
        }
        return faction;
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        Set<String> factionNames = this.plugin.getFactionLogic().getFactionsNames();
        ArrayList<String> list = new ArrayList<String>(factionNames);
        Collections.sort(list);
        if (args.hasNext()) {
            String charSequence = ((String)args.nextIfPresent().get()).toLowerCase();
            return list.stream().filter(x -> x.contains(charSequence)).collect(Collectors.toList());
        }
        return list;
    }
}

