/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.listeners;

import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.listeners.AbstractListener;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import io.github.aquerr.eaglefactions.common.version.VersionChecker;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class PlayerJoinListener
extends AbstractListener {
    private final ProtectionConfig protectionConfig;

    public PlayerJoinListener(EagleFactions plugin) {
        super(plugin);
        this.protectionConfig = plugin.getConfiguration().getProtectionConfig();
    }

    @Listener(order=Order.POST)
    public void onPlayerJoin(ClientConnectionEvent.Join event, @Root Player player) {
        CompletableFuture.runAsync(() -> {
            Optional<Faction> optionalPlayerFaction;
            if (player.hasPermission("eaglefactions.admin.version.notify") && !VersionChecker.isLatest("0.15.2_394-SNAPSHOT")) {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, Messages.A_NEW_VERSION_OF + " ", TextColors.AQUA, "Eagle Factions", TextColors.GREEN, " " + Messages.IS_AVAILABLE}));
            }
            if (!super.getPlugin().getPlayerManager().getFactionPlayer(player.getUniqueId()).isPresent()) {
                super.getPlugin().getPlayerManager().addPlayer(player.getUniqueId(), player.getName());
            }
            super.getPlugin().getPowerManager().startIncreasingPower(player.getUniqueId());
            if (!this.protectionConfig.getDetectedWorldNames().contains(player.getWorld().getName())) {
                this.protectionConfig.addWorld(player.getWorld().getName());
            }
            if ((optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId())).isPresent() && !optionalPlayerFaction.get().getMessageOfTheDay().equals("")) {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_MESSAGE_OF_THE_DAY, TextColors.RESET, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, optionalPlayerFaction.get().getName()}))), Text.of((String)optionalPlayerFaction.get().getMessageOfTheDay())}));
            }
        });
    }
}

