/*
 * Decompiled with CFR 0.152.
 */
package elucent.simplytea.item;

import elucent.simplytea.SimplyTea;
import elucent.simplytea.core.Config;
import elucent.simplytea.core.IModeledObject;
import elucent.simplytea.core.Util;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTeaCup
extends ItemFood
implements IModeledObject {
    private boolean isRestful;

    public ItemTeaCup(String name, int hunger, float saturation) {
        super(hunger, saturation, false);
        Util.init((Item)this, name, true);
        this.func_77625_d(1);
        this.isRestful = false;
    }

    public ItemTeaCup(String name, int hunger, double saturation) {
        this(name, hunger, (float)saturation);
    }

    public ItemTeaCup(String name, Config.CaffeineTea stats, int level) {
        this(name, stats.hunger, stats.saturation);
        if (stats.caffeinated_time > 0) {
            this.func_185070_a(new PotionEffect(SimplyTea.caffeinated, stats.caffeinated_time * 20, level), 1.0f);
        }
    }

    public ItemTeaCup(String name, Config.HerbalTea stats, int seconds) {
        this(name, stats.hunger, stats.saturation);
        if (stats.hearts > 0) {
            this.isRestful = true;
            this.func_185070_a(new PotionEffect(SimplyTea.restful, seconds * 20, stats.hearts - 1), 1.0f);
        }
    }

    public ItemTeaCup(String name, Config.ChorusTea stats) {
        this(name, stats.hunger, stats.saturation);
        if (stats.enderfalling_time > 0) {
            this.func_185070_a(new PotionEffect(SimplyTea.enderfalling, stats.enderfalling_time * 20, 0), 1.0f);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77952_i() > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77952_i() > 0) {
            return (double)stack.func_77952_i() / 2.0;
        }
        return 0.0;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase base) {
        ItemStack s = stack.func_77946_l();
        super.func_77654_b(stack, world, base);
        s.func_77964_b(stack.func_77952_i() + 1);
        if (s.func_77952_i() >= 2) {
            return new ItemStack(SimplyTea.cup, 1);
        }
        return s;
    }

    protected void func_77849_c(ItemStack stack, World worldIn, EntityPlayer player) {
        if (!worldIn.field_72995_K) {
            player.curePotionEffects(stack);
            if (!this.isRestful || !player.func_70644_a(SimplyTea.caffeinated)) {
                super.func_77849_c(stack, worldIn, player);
            }
        }
    }
}

