/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.meta;

import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.ChatMetaNode;

public class MetaRemoveChatMeta
extends GenericChildCommand {
    private final ChatMetaType type;

    public static MetaRemoveChatMeta forPrefix() {
        return new MetaRemoveChatMeta(ChatMetaType.PREFIX, CommandSpec.META_REMOVEPREFIX, "removeprefix", CommandPermission.USER_META_REMOVE_PREFIX, CommandPermission.GROUP_META_REMOVE_PREFIX);
    }

    public static MetaRemoveChatMeta forSuffix() {
        return new MetaRemoveChatMeta(ChatMetaType.SUFFIX, CommandSpec.META_REMOVESUFFIX, "removesuffix", CommandPermission.USER_META_REMOVE_SUFFIX, CommandPermission.GROUP_META_REMOVE_SUFFIX);
    }

    private MetaRemoveChatMeta(ChatMetaType type, CommandSpec spec, String name, CommandPermission userPermission, CommandPermission groupPermission) {
        super(spec, name, userPermission, groupPermission, Predicates.is(0));
        this.type = type;
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder target, ArgumentList args, String label, CommandPermission permission) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, permission, target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        int priority = args.getPriority(0);
        String meta = args.getOrDefault(1, "null");
        ImmutableContextSet context = args.getContextOrDefault(2, plugin).immutableCopy();
        if (ArgumentPermissions.checkContext(plugin, sender, permission, context) || ArgumentPermissions.checkGroup(plugin, sender, target, (ContextSet)context)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        if (meta.equalsIgnoreCase("null") || meta.equals("*")) {
            target.removeIf(DataType.NORMAL, context, this.type.nodeType().predicate(n -> n.getPriority() == priority && !n.hasExpiry()), false);
            Message.BULK_REMOVE_CHATMETA_SUCCESS.send(sender, target, this.type, priority, context);
            LoggedAction.build().source(sender).target(target).description("meta", "remove" + this.type.name().toLowerCase(), priority, "*", context).build().submit(plugin, sender);
            StorageAssistant.save(target, sender, plugin);
            return CommandResult.SUCCESS;
        }
        DataMutateResult result = target.unsetNode(DataType.NORMAL, (Node)((ChatMetaNode.Builder)this.type.builder(meta, priority).withContext(context)).build());
        if (result.wasSuccessful()) {
            Message.REMOVE_CHATMETA_SUCCESS.send(sender, target, this.type, meta, priority, context);
            LoggedAction.build().source(sender).target(target).description("meta", "remove" + this.type.name().toLowerCase(), priority, meta, context).build().submit(plugin, sender);
            StorageAssistant.save(target, sender, plugin);
            return CommandResult.SUCCESS;
        }
        Message.DOES_NOT_HAVE_CHAT_META.send(sender, target, this.type, meta, priority, context);
        return CommandResult.STATE_ERROR;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().from(2, TabCompletions.contexts(plugin)).complete((List<String>)((Object)args));
    }
}

