/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.log;

import java.util.List;
import java.util.UUID;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Paginated;
import me.lucko.luckperms.common.util.Predicates;

public class LogRecent
extends ChildCommand<Log> {
    private static final int ENTRIES_PER_PAGE = 10;

    public LogRecent() {
        super(CommandSpec.LOG_RECENT, "recent", CommandPermission.LOG_RECENT, Predicates.notInRange(0, 2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Log log, ArgumentList args, String label) {
        if (args.isEmpty()) {
            Paginated<LoggedAction> content = new Paginated<LoggedAction>(log.getContent());
            return LogRecent.showLog(content.getMaxPages(10), false, sender, content);
        }
        int page = args.getIntOrDefault(0, Integer.MIN_VALUE);
        if (page != Integer.MIN_VALUE) {
            Paginated<LoggedAction> content = new Paginated<LoggedAction>(log.getContent());
            return LogRecent.showLog(page, false, sender, content);
        }
        UUID uuid = args.getUserTarget(0, plugin, sender);
        if (uuid == null) {
            return CommandResult.INVALID_ARGS;
        }
        Paginated<LoggedAction> content = new Paginated<LoggedAction>(log.getContent(uuid));
        page = args.getIntOrDefault(1, Integer.MIN_VALUE);
        if (page != Integer.MIN_VALUE) {
            return LogRecent.showLog(page, true, sender, content);
        }
        return LogRecent.showLog(content.getMaxPages(10), true, sender, content);
    }

    private static CommandResult showLog(int page, boolean specificUser, Sender sender, Paginated<LoggedAction> log) {
        int maxPage = log.getMaxPages(10);
        if (maxPage == 0) {
            Message.LOG_NO_ENTRIES.send(sender);
            return CommandResult.STATE_ERROR;
        }
        if (page < 1 || page > maxPage) {
            Message.LOG_INVALID_PAGE_RANGE.send(sender, maxPage);
            return CommandResult.INVALID_ARGS;
        }
        List<Paginated.Entry<LoggedAction>> entries = log.getPage(page, 10);
        if (specificUser) {
            String name = ((LoggedAction)((Paginated.Entry)entries.stream().findAny().get()).value()).getSource().getName();
            if (name.contains("@")) {
                name = name.split("@")[0];
            }
            Message.LOG_RECENT_BY_HEADER.send(sender, name, page, maxPage);
        } else {
            Message.LOG_RECENT_HEADER.send(sender, page, maxPage);
        }
        for (Paginated.Entry<LoggedAction> e : entries) {
            Message.LOG_ENTRY.send(sender, e.position(), e.value());
        }
        return CommandResult.SUCCESS;
    }
}

