/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.CompletionSupplier;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.http.UnsuccessfulRequestException;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.verbose.InvalidFilterException;
import me.lucko.luckperms.common.verbose.VerboseFilter;
import me.lucko.luckperms.common.verbose.VerboseHandler;
import me.lucko.luckperms.common.verbose.VerboseListener;

public class VerboseCommand
extends SingleCommand {
    public VerboseCommand() {
        super(CommandSpec.VERBOSE, "Verbose", CommandPermission.VERBOSE, Predicates.is(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, ArgumentList args, String label) {
        if (args.isEmpty()) {
            this.sendUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        VerboseHandler verboseHandler = plugin.getVerboseHandler();
        String mode = args.get(0).toLowerCase();
        if (mode.equals("command") || mode.equals("cmd")) {
            Sender executor;
            if (args.size() < 3) {
                this.sendDetailedUsage(sender, label);
                return CommandResult.INVALID_ARGS;
            }
            String name = args.get(1);
            if (name.equals("me") || name.equals("self") || name.equalsIgnoreCase(sender.getName())) {
                executor = sender;
            } else {
                if (!CommandPermission.VERBOSE_COMMAND_OTHERS.isAuthorized(sender)) {
                    Message.COMMAND_NO_PERMISSION.send(sender);
                    return CommandResult.NO_PERMISSION;
                }
                executor = plugin.getOnlineSenders().filter(s -> !s.isConsole()).filter(s -> s.getName().equalsIgnoreCase(name)).findAny().orElse(null);
                if (executor == null) {
                    Message.USER_NOT_ONLINE.send(sender, name);
                    return CommandResult.STATE_ERROR;
                }
            }
            String commandWithSlash = String.join((CharSequence)" ", (Iterable<? extends CharSequence>)((Object)args.subList(2, args.size())));
            String command = commandWithSlash.charAt(0) == '/' ? commandWithSlash.substring(1) : commandWithSlash;
            plugin.getBootstrap().getScheduler().sync().execute(() -> {
                Message.VERBOSE_ON_COMMAND.send(sender, executor.getName(), command);
                verboseHandler.registerListener(sender, VerboseFilter.acceptAll(), true);
                executor.performCommand(command);
                VerboseListener listener = verboseHandler.unregisterListener(sender);
                if (listener.getMatchedCount() == 0) {
                    Message.VERBOSE_OFF_COMMAND_NO_CHECKS.send(sender);
                } else {
                    Message.VERBOSE_OFF_COMMAND.send(sender);
                }
            });
            return CommandResult.SUCCESS;
        }
        if (mode.equals("on") || mode.equals("true") || mode.equals("record")) {
            VerboseFilter compiledFilter;
            ArrayList filters = new ArrayList();
            if (args.size() != 1) {
                filters.addAll(args.subList(1, args.size()));
            }
            String filter = filters.isEmpty() ? "" : String.join((CharSequence)" ", filters);
            try {
                compiledFilter = VerboseFilter.compile(filter);
            }
            catch (InvalidFilterException e) {
                Message.VERBOSE_INVALID_FILTER.send(sender, filter, e.getCause().getMessage());
                return CommandResult.FAILURE;
            }
            boolean notify = !mode.equals("record");
            verboseHandler.registerListener(sender, compiledFilter, notify);
            if (notify) {
                if (!filter.isEmpty()) {
                    Message.VERBOSE_ON_QUERY.send(sender, filter);
                    return CommandResult.SUCCESS;
                } else {
                    Message.VERBOSE_ON.send(sender);
                }
                return CommandResult.SUCCESS;
            } else if (!filter.isEmpty()) {
                Message.VERBOSE_RECORDING_ON_QUERY.send(sender, filter);
                return CommandResult.SUCCESS;
            } else {
                Message.VERBOSE_RECORDING_ON.send(sender);
            }
            return CommandResult.SUCCESS;
        }
        if (mode.equals("off") || mode.equals("false") || mode.equals("paste") || mode.equals("upload")) {
            VerboseListener listener = verboseHandler.unregisterListener(sender);
            if (mode.equals("paste") || mode.equals("upload")) {
                String id;
                if (listener == null) {
                    Message.VERBOSE_OFF.send(sender);
                    return CommandResult.SUCCESS;
                }
                Message.VERBOSE_UPLOAD_START.send(sender);
                try {
                    id = listener.uploadPasteData(plugin.getBytebin());
                }
                catch (UnsuccessfulRequestException e) {
                    Message.GENERIC_HTTP_REQUEST_FAILURE.send(sender, e.getResponse().code(), e.getResponse().message());
                    return CommandResult.STATE_ERROR;
                }
                catch (IOException e) {
                    plugin.getLogger().warn("Error uploading data to bytebin", e);
                    Message.GENERIC_HTTP_UNKNOWN_FAILURE.send(sender);
                    return CommandResult.STATE_ERROR;
                }
                String url = plugin.getConfiguration().get(ConfigKeys.VERBOSE_VIEWER_URL_PATTERN) + id;
                Message.VERBOSE_RESULTS_URL.send(sender, url);
                return CommandResult.SUCCESS;
            }
            Message.VERBOSE_OFF.send(sender);
            return CommandResult.SUCCESS;
        }
        this.sendUsage(sender, label);
        return CommandResult.INVALID_ARGS;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().at(0, CompletionSupplier.startsWith("on", "record", "off", "upload", "command")).complete((List<String>)((Object)args));
    }
}

