/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model.nodemap;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.luckperms.api.node.Node;

public class MutateResult {
    private final LinkedHashSet<Change> changes = new LinkedHashSet();

    public Set<Change> getChanges() {
        return this.changes;
    }

    public Set<Node> getChanges(ChangeType type) {
        LinkedHashSet<Node> changes = new LinkedHashSet<Node>(this.changes.size());
        for (Change change : this.changes) {
            if (change.getType() != type) continue;
            changes.add(change.getNode());
        }
        return changes;
    }

    void clear() {
        this.changes.clear();
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public Set<Node> getAdded() {
        return this.getChanges(ChangeType.ADD);
    }

    public Set<Node> getRemoved() {
        return this.getChanges(ChangeType.REMOVE);
    }

    private void recordChange(Change change) {
        if (this.changes.remove(change.inverse())) {
            return;
        }
        this.changes.add(change);
    }

    public void recordChange(ChangeType type, Node node) {
        this.recordChange(new Change(type, node));
    }

    public void recordChanges(ChangeType type, Iterable<Node> nodes) {
        for (Node node : nodes) {
            this.recordChange(new Change(type, node));
        }
    }

    public MutateResult mergeFrom(MutateResult other) {
        for (Change change : other.changes) {
            this.recordChange(change);
        }
        return this;
    }

    public String toString() {
        return "MutateResult{changes=" + this.changes + '}';
    }

    public static enum ChangeType {
        ADD,
        REMOVE;


        public ChangeType inverse() {
            return this == ADD ? REMOVE : ADD;
        }
    }

    public static final class Change {
        private final ChangeType type;
        private final Node node;

        public Change(ChangeType type, Node node) {
            this.type = type;
            this.node = node;
        }

        public ChangeType getType() {
            return this.type;
        }

        public Node getNode() {
            return this.node;
        }

        public Change inverse() {
            return new Change(this.type.inverse(), this.node);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Change change = (Change)o;
            return this.type == change.type && this.node.equals(change.node);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.node});
        }

        public String toString() {
            return "Change{type=" + (Object)((Object)this.type) + ", node=" + this.node + '}';
        }
    }
}

