/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model.nodemap;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.lucko.luckperms.common.model.nodemap.MutateResult;
import me.lucko.luckperms.common.model.nodemap.NodeMap;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.query.QueryOptions;

public class RecordedNodeMap
implements NodeMap {
    private final NodeMap delegate;
    private final Lock lock = new ReentrantLock();
    private MutateResult changes = new MutateResult();

    public RecordedNodeMap(NodeMap delegate) {
        this.delegate = delegate;
    }

    public NodeMap bypass() {
        return this.delegate;
    }

    public void discardChanges() {
        this.lock.lock();
        try {
            this.changes.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutateResult exportChanges(Predicate<MutateResult> onlyIf) {
        this.lock.lock();
        try {
            MutateResult existing = this.changes;
            if (onlyIf.test(existing)) {
                this.changes = new MutateResult();
                MutateResult mutateResult = existing;
                return mutateResult;
            }
            MutateResult mutateResult = null;
            return mutateResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    private MutateResult record(MutateResult result) {
        this.lock.lock();
        try {
            this.changes.mergeFrom(result);
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public MutateResult add(Node nodeWithoutInheritanceOrigin) {
        return this.record(this.delegate.add(nodeWithoutInheritanceOrigin));
    }

    @Override
    public MutateResult remove(Node node) {
        return this.record(this.delegate.remove(node));
    }

    @Override
    public MutateResult removeExact(Node node) {
        return this.record(this.delegate.removeExact(node));
    }

    @Override
    public MutateResult removeIf(Predicate<? super Node> predicate) {
        return this.record(this.delegate.removeIf(predicate));
    }

    @Override
    public MutateResult removeIf(ContextSet contextSet, Predicate<? super Node> predicate) {
        return this.record(this.delegate.removeIf(contextSet, predicate));
    }

    @Override
    public MutateResult removeThenAdd(Node nodeToRemove, Node nodeToAdd) {
        return this.record(this.delegate.removeThenAdd(nodeToRemove, nodeToAdd));
    }

    @Override
    public MutateResult clear() {
        return this.record(this.delegate.clear());
    }

    @Override
    public MutateResult clear(ContextSet contextSet) {
        return this.record(this.delegate.clear(contextSet));
    }

    @Override
    public MutateResult setContent(Iterable<? extends Node> set) {
        return this.record(this.delegate.setContent(set));
    }

    @Override
    public MutateResult setContent(Stream<? extends Node> stream) {
        return this.record(this.delegate.setContent(stream));
    }

    @Override
    public MutateResult addAll(Iterable<? extends Node> set) {
        return this.record(this.delegate.addAll(set));
    }

    @Override
    public MutateResult addAll(Stream<? extends Node> stream) {
        return this.record(this.delegate.addAll(stream));
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public List<Node> asList() {
        return this.delegate.asList();
    }

    @Override
    public LinkedHashSet<Node> asSet() {
        return this.delegate.asSet();
    }

    @Override
    public SortedSet<Node> asSortedSet() {
        return this.delegate.asSortedSet();
    }

    @Override
    public ImmutableSet<Node> asImmutableSet() {
        return this.delegate.asImmutableSet();
    }

    @Override
    public Map<ImmutableContextSet, Collection<Node>> asMap() {
        return this.delegate.asMap();
    }

    @Override
    public List<InheritanceNode> inheritanceAsList() {
        return this.delegate.inheritanceAsList();
    }

    @Override
    public LinkedHashSet<InheritanceNode> inheritanceAsSet() {
        return this.delegate.inheritanceAsSet();
    }

    @Override
    public SortedSet<InheritanceNode> inheritanceAsSortedSet() {
        return this.delegate.inheritanceAsSortedSet();
    }

    @Override
    public ImmutableSet<InheritanceNode> inheritanceAsImmutableSet() {
        return this.delegate.inheritanceAsImmutableSet();
    }

    @Override
    public Map<ImmutableContextSet, Collection<InheritanceNode>> inheritanceAsMap() {
        return this.delegate.inheritanceAsMap();
    }

    @Override
    public void forEach(Consumer<? super Node> consumer) {
        this.delegate.forEach(consumer);
    }

    @Override
    public void forEach(QueryOptions filter, Consumer<? super Node> consumer) {
        this.delegate.forEach(filter, consumer);
    }

    @Override
    public void copyTo(Collection<? super Node> collection) {
        this.delegate.copyTo(collection);
    }

    @Override
    public void copyTo(ImmutableCollection.Builder<? super Node> collection) {
        this.delegate.copyTo(collection);
    }

    @Override
    public void copyTo(Collection<? super Node> collection, QueryOptions filter) {
        this.delegate.copyTo(collection, filter);
    }

    @Override
    public <T extends Node> void copyTo(Collection<? super T> collection, NodeType<T> type, QueryOptions filter) {
        this.delegate.copyTo(collection, type, filter);
    }

    @Override
    public void copyInheritanceNodesTo(Collection<? super InheritanceNode> collection) {
        this.delegate.copyInheritanceNodesTo(collection);
    }

    @Override
    public void copyInheritanceNodesTo(ImmutableCollection.Builder<? super InheritanceNode> collection) {
        this.delegate.copyInheritanceNodesTo(collection);
    }

    @Override
    public void copyInheritanceNodesTo(Collection<? super InheritanceNode> collection, QueryOptions filter) {
        this.delegate.copyInheritanceNodesTo(collection, filter);
    }

    @Override
    public Collection<Node> nodesInContext(ContextSet context) {
        return this.delegate.nodesInContext(context);
    }

    @Override
    public Collection<InheritanceNode> inheritanceNodesInContext(ContextSet context) {
        return this.delegate.inheritanceNodesInContext(context);
    }
}

