/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.factory;

import com.google.common.base.Splitter;
import java.util.regex.Pattern;
import me.lucko.luckperms.common.cache.PatternCache;
import me.lucko.luckperms.common.node.AbstractNode;

public final class Delimiters {
    public static final char DELIMITER = '\\';
    public static final Splitter SPLIT_BY_NODE_SEPARATOR_IN_TWO = Splitter.on((Pattern)PatternCache.compile("(?<!" + Pattern.quote(String.valueOf('\\')) + ")" + Pattern.quote(AbstractNode.NODE_SEPARATOR_STRING))).limit(2);

    private Delimiters() {
    }

    private static boolean isDelimitedCharacter(char c) {
        return c == '.';
    }

    private static boolean isLegacyDelimitedCharacter(char c) {
        return c == '.' || c == '/' || c == '-' || c == '$';
    }

    public static String escapeCharacters(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        char[] chars = s.toCharArray();
        int count = 0;
        for (char c : chars) {
            if (!Delimiters.isDelimitedCharacter(c)) continue;
            ++count;
        }
        if (count == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(chars.length + count);
        for (char c : chars) {
            if (Delimiters.isDelimitedCharacter(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapeCharacters(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        char[] chars = s.toCharArray();
        int count = 0;
        int j = chars.length - 1;
        for (int i = 0; i < j; ++i) {
            if (chars[i] != '\\' || !Delimiters.isLegacyDelimitedCharacter(chars[i + 1])) continue;
            ++count;
        }
        if (count == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(chars.length - count);
        int i = 0;
        while (i < chars.length) {
            if (i < chars.length - 1 && chars[i] == '\\' && Delimiters.isLegacyDelimitedCharacter(chars[i + 1])) {
                sb.append(chars[i + 1]);
                i += 2;
                continue;
            }
            sb.append(chars[i]);
            ++i;
        }
        return sb.toString();
    }
}

