/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.types;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import me.lucko.luckperms.common.node.AbstractNode;
import me.lucko.luckperms.common.node.AbstractNodeBuilder;
import me.lucko.luckperms.common.node.factory.Delimiters;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.metadata.NodeMetadataKey;
import net.luckperms.api.node.types.MetaNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Meta
extends AbstractNode<MetaNode, MetaNode.Builder>
implements MetaNode {
    private static final String NODE_KEY = "meta";
    private static final String NODE_MARKER = "meta.";
    private final String metaKey;
    private final String metaValue;

    public static String key(String key, String value) {
        return NODE_MARKER + Delimiters.escapeCharacters(key).toLowerCase() + '.' + Delimiters.escapeCharacters(value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String key, String value) {
        return Meta.builder().key(key).value(value);
    }

    public Meta(String metaKey, String metaValue, boolean value, long expireAt, ImmutableContextSet contexts, Map<NodeMetadataKey<?>, Object> metadata) {
        super(Meta.key(metaKey, metaValue), value, expireAt, contexts, metadata);
        this.metaKey = metaKey.toLowerCase();
        this.metaValue = metaValue;
    }

    @Override
    public @NonNull String getMetaKey() {
        return this.metaKey;
    }

    @Override
    public @NonNull String getMetaValue() {
        return this.metaValue;
    }

    @Override
    public @NonNull Builder toBuilder() {
        return new Builder(this.metaKey, this.metaValue, this.value, this.expireAt, this.contexts, this.metadata);
    }

    public static @Nullable Builder parse(String key) {
        if (!key.toLowerCase().startsWith(NODE_MARKER)) {
            return null;
        }
        Iterator metaParts = Delimiters.SPLIT_BY_NODE_SEPARATOR_IN_TWO.split((CharSequence)key.substring(NODE_MARKER.length())).iterator();
        if (!metaParts.hasNext()) {
            return null;
        }
        String metaKey = (String)metaParts.next();
        if (!metaParts.hasNext()) {
            return null;
        }
        String metaValue = (String)metaParts.next();
        return Meta.builder().key(Delimiters.unescapeCharacters(metaKey)).value(Delimiters.unescapeCharacters(metaValue));
    }

    public static final class Builder
    extends AbstractNodeBuilder<MetaNode, MetaNode.Builder>
    implements MetaNode.Builder {
        private String metaKey;
        private String metaValue;

        private Builder() {
            this.metaKey = null;
            this.metaValue = null;
        }

        public Builder(String metaKey, String metaValue, boolean value, long expireAt, ImmutableContextSet context, Map<NodeMetadataKey<?>, Object> metadata) {
            super(value, expireAt, context, metadata);
            this.metaKey = metaKey;
            this.metaValue = metaValue;
        }

        @Override
        public @NonNull Builder key(@NonNull String key) {
            this.metaKey = Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        public @NonNull Builder value(@NonNull String value) {
            this.metaValue = Objects.requireNonNull(value, "value");
            return this;
        }

        @Override
        public @NonNull Meta build() {
            Objects.requireNonNull(this.metaKey, "metaKey");
            Objects.requireNonNull(this.metaValue, "metaValue");
            return new Meta(this.metaKey, this.metaValue, this.value, this.expireAt, this.context.build(), this.metadata);
        }
    }
}

