/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge;

import java.util.UUID;
import me.lucko.luckperms.common.locale.TranslationManager;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.sender.SenderFactory;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.GsonComponentSerializer;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import me.lucko.luckperms.sponge.service.CompatibilityUtil;
import net.luckperms.api.util.Tristate;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

public class SpongeSenderFactory
extends SenderFactory<LPSpongePlugin, CommandSource> {
    public SpongeSenderFactory(LPSpongePlugin plugin) {
        super(plugin);
    }

    @Override
    protected String getName(CommandSource source) {
        if (source instanceof Player) {
            return source.getName();
        }
        return "Console";
    }

    @Override
    protected UUID getUniqueId(CommandSource source) {
        if (source instanceof Player) {
            return ((Player)source).getUniqueId();
        }
        return Sender.CONSOLE_UUID;
    }

    @Override
    protected void sendMessage(CommandSource source, Component message) {
        source.sendMessage(SpongeSenderFactory.toNativeText(TranslationManager.render(message, source.getLocale())));
    }

    @Override
    protected Tristate getPermissionValue(CommandSource source, String node) {
        Tristate result = CompatibilityUtil.convertTristate(source.getPermissionValue(source.getActiveContexts(), node));
        if (result == Tristate.UNDEFINED && source.hasPermission(node)) {
            result = Tristate.TRUE;
        }
        return result;
    }

    @Override
    protected boolean hasPermission(CommandSource source, String node) {
        return source.hasPermission(node);
    }

    @Override
    protected void performCommand(CommandSource source, String command) {
        ((LPSpongePlugin)this.getPlugin()).getBootstrap().getGame().getCommandManager().process(source, command);
    }

    public static Text toNativeText(Component component) {
        return TextSerializers.JSON.deserialize((String)GsonComponentSerializer.gson().serialize(component));
    }
}

