/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.node;

import java.time.Duration;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.node.ScopedNode;
import net.luckperms.api.node.metadata.NodeMetadataKey;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface NodeBuilder<N extends ScopedNode<N, B>, B extends NodeBuilder<N, B>> {
    public @NonNull B value(boolean var1);

    public @NonNull B negated(boolean var1);

    public @NonNull B expiry(long var1);

    public @NonNull B expiry(@Nullable TemporalAccessor var1);

    public @NonNull B expiry(@Nullable TemporalAmount var1);

    default public @NonNull B expiry(long duration, TimeUnit unit) {
        if (duration <= 0L) {
            throw new IllegalArgumentException("duration must be positive");
        }
        long seconds = Objects.requireNonNull(unit, "unit").toSeconds(duration);
        return this.expiry(Duration.ofSeconds(seconds));
    }

    public @NonNull B clearExpiry();

    public @NonNull B context(@NonNull ContextSet var1);

    public @NonNull B withContext(@NonNull String var1, @NonNull String var2);

    public @NonNull B withContext(@NonNull ContextSet var1);

    public <T> @NonNull B withMetadata(@NonNull NodeMetadataKey<T> var1, @Nullable T var2);

    public @NonNull N build();
}

