/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.blocks;

import java.util.ArrayList;
import java.util.PriorityQueue;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vswe.superfactory.SuperFactoryManager;
import vswe.superfactory.api.ICable;
import vswe.superfactory.registry.ModBlocks;
import vswe.superfactory.tiles.TileEntityManager;
import vswe.superfactory.util.WorldCoordinate;

public class BlockCable
extends Block
implements ICable {
    public BlockCable() {
        super(Material.field_151573_f);
        this.func_149647_a(SuperFactoryManager.creativeTab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c("sfm.cable");
        this.func_149711_c(0.4f);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        BlockCable.updateInventories((IBlockAccess)world, pos);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        BlockCable.updateInventories((IBlockAccess)world, pos);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        BlockCable.updateInventories(world, pos);
    }

    public static void updateInventories(IBlockAccess world, BlockPos pos) {
        ArrayList<WorldCoordinate> visited = new ArrayList<WorldCoordinate>();
        PriorityQueue<WorldCoordinate> queue = new PriorityQueue<WorldCoordinate>();
        WorldCoordinate start = new WorldCoordinate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0);
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty()) {
            WorldCoordinate element = (WorldCoordinate)queue.poll();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        WorldCoordinate target;
                        if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 1 || visited.contains(target = new WorldCoordinate(element.getX() + x, element.getY() + y, element.getZ() + z, element.getDepth() + 1))) continue;
                        visited.add(target);
                        IBlockState block = world.func_180495_p(new BlockPos(x, y, z));
                        int meta = block.func_177230_c().func_176201_c(block);
                        if (block.func_177230_c() == ModBlocks.MANAGER) {
                            TileEntity tileEntity = world.func_175625_s(new BlockPos(target.getX(), target.getY(), target.getZ()));
                            if (!(tileEntity instanceof TileEntityManager)) continue;
                            ((TileEntityManager)tileEntity).updateInventories();
                            continue;
                        }
                        if (!BlockCable.isCable(block.func_177230_c(), meta)) continue;
                        queue.add(target);
                    }
                }
            }
        }
    }

    public static boolean isCable(Block block, int meta) {
        return block instanceof ICable;
    }

    @Override
    public boolean isCable() {
        return true;
    }
}

