/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.ilexiconn.llibrary.server.command.Command;
import net.ilexiconn.llibrary.server.command.ICommandExecutor;
import net.ilexiconn.llibrary.server.command.argument.ArgumentParsers;
import net.ilexiconn.llibrary.server.command.argument.IArgumentParser;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

public enum CommandHandler {
    INSTANCE;

    private Map<Class<?>, IArgumentParser<?>> argumentParserMap = new HashMap();

    public <T> void registerArgumentParser(Class<T> type, IArgumentParser<T> argumentParser) {
        this.argumentParserMap.put(type, argumentParser);
    }

    public <T extends Enum<T>> IArgumentParser<T> getEnumParser(final Class<T> enumClass) {
        return new IArgumentParser<T>(){
            private String[] values;
            {
                this.values = (String[])Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).map(s -> s.toLowerCase(Locale.ENGLISH)).toArray(String[]::new);
            }

            @Override
            public T parseArgument(MinecraftServer server, ICommandSender sender, String argument) {
                return Enum.valueOf(enumClass, argument.toUpperCase(Locale.ENGLISH));
            }

            @Override
            public List<String> getTabCompletion(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
                return CommandBase.func_71530_a((String[])args, (String[])this.values);
            }
        };
    }

    public <T> IArgumentParser<T> getParserForType(Class<T> type) {
        IArgumentParser<T> argumentParser = ArgumentParsers.getBuiltinParser(type);
        if (argumentParser != null) {
            return argumentParser;
        }
        if (this.argumentParserMap.containsKey(type)) {
            return this.argumentParserMap.get(type);
        }
        return null;
    }

    public void registerCommand(FMLServerStartingEvent event, Command command, ICommandExecutor executor) {
        event.registerServerCommand((ICommand)command.setExecutor(executor));
    }
}

