/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.switches;

import net.malisis.core.util.blockdata.BlockDataHandler;
import net.malisis.switches.PowerData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PowerManager {
    public static String POWER_BLOCK_DATA = "malisisswitches:powerAmount";
    private static PowerManager instance = new PowerManager();

    public int getPower(World world, BlockPos pos, EnumFacing side) {
        PowerData data = (PowerData)BlockDataHandler.getData((String)POWER_BLOCK_DATA, (IBlockAccess)world, (BlockPos)pos);
        return data != null ? data.getPower() : 0;
    }

    public static void setPower(World world, BlockPos pos, int amount, boolean sendToClients) {
        if (amount <= 0) {
            BlockDataHandler.removeData((String)POWER_BLOCK_DATA, (IBlockAccess)world, (BlockPos)pos, (boolean)sendToClients);
            return;
        }
        if (amount > 15) {
            amount = 15;
        }
        BlockDataHandler.setData((String)POWER_BLOCK_DATA, (IBlockAccess)world, (BlockPos)pos, (Object)new PowerData(15), (boolean)sendToClients);
    }

    public static int getRedstonePower(World world, BlockPos pos, EnumFacing side) {
        int power = instance.getPower(world, pos, side);
        if (power >= 15) {
            return power;
        }
        if ((power = Math.max(power, instance.getPower(world, pos.func_177972_a(side.func_176734_d()), side))) >= 15) {
            return power;
        }
        int blockPower = 0;
        IBlockState state = world.func_180495_p(pos);
        blockPower = state.func_177230_c().shouldCheckWeakPower(state, (IBlockAccess)world, pos, side) ? world.func_175676_y(pos) : state.func_185911_a((IBlockAccess)world, pos, side);
        return Math.max(power, blockPower);
    }

    public static void registerBlockData() {
        BlockDataHandler.registerBlockData((String)POWER_BLOCK_DATA, PowerData::fromBytes, PowerData::toBytes);
    }
}

