/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.apache.commons.lang3.tuple.Pair;
import theking530.staticpower.assists.RegisterHelper;
import theking530.staticpower.handlers.crafting.Craft;
import theking530.staticpower.handlers.crafting.wrappers.GrinderOutputWrapper;
import theking530.staticpower.items.FormerMolds;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.utils.Utils;

public class ModuleStaticPower
extends ModuleBase {
    public static final ArrayList<String> FULL_BLACKLIST = Lists.newArrayList((Object[])new String[]{"Copper", "Silver", "Tin", "Lead", "Platinum", "Nickel", "Aluminium", "Iron", "Gold", "Ruby", "Sapphire", "Static", "Energized", "Lumum", "InertInfusion", "RestoneAlloy", "Coal", "Bronze", "Redstone", "Sulfur", "Saltpeter", "Potash", "Bitumen", "Salt", "Prismarine"});
    public static final ArrayList<String> ORE_BLACKLIST = Lists.newArrayList((Object[])new String[]{"QuartzBlack", "Manganese", "Mithril", "Zinc", "Adamantine", "Alduorite", "AstralSilver", "Atlarus", "Carmot", "Ceruclase", "DeepIron", "Eximite", "Ignatius", "Infuscolium", "Kalendrite", "Lemurite", "Magnesium", "Meutoite", "Midasium", "Orichalum", "Oureclase", "Prometheum", "Rubracium", "Sanguinite", "ShadowIron", "Vulcanite", "Vyroxeres", "Diamond", "Emerald", "Quartz", "Lapis"});
    public static final ArrayList<String> DUST_BLACKLIST = Lists.newArrayList();

    @Override
    public String getName() {
        return "staticpower";
    }

    @Override
    public List<String> getDependencies() {
        return Lists.newArrayList((Object[])new String[]{"dust"});
    }

    @Override
    public List<String> getOreBlacklist() {
        return FULL_BLACKLIST;
    }

    @Override
    public EnumSet<EnumOreType> getOreTypes() {
        return EnumSet.allOf(EnumOreType.class);
    }

    @Override
    public void init() {
        for (IOreEntry entry : JAOPCAApi.MODULE_TO_ORES_MAP.get((Object)this)) {
            switch (entry.getOreType()) {
                case INGOT: {
                    if (!ORE_BLACKLIST.contains(entry.getOreName())) {
                        ArrayList list = Lists.newArrayList();
                        list.add(Pair.of((Object)Utils.getOreStack("dust", entry, 2), (Object)Float.valueOf(1.0f)));
                        if (entry.hasExtra()) {
                            list.add(Pair.of((Object)Utils.getOreStackExtra("dust", entry, 1), (Object)Float.valueOf(0.05f)));
                        }
                        ModuleStaticPower.addGrinderRecipe(CraftingHelper.getIngredient((Object)("ore" + entry.getOreName())), list);
                    }
                }
                case INGOT_ORELESS: {
                    if (DUST_BLACKLIST.contains(entry.getOreName())) break;
                    ModuleStaticPower.addGrinderRecipe("ingot" + entry.getOreName(), Utils.getOreStackExtra("dust", entry, 1), 1.0f);
                    break;
                }
                case GEM: {
                    if (!ORE_BLACKLIST.contains(entry.getOreName())) {
                        ModuleStaticPower.addGrinderRecipe("ore" + entry.getOreName(), Utils.getOreStack("gem", entry, 3), 1.0f);
                    }
                }
                case GEM_ORELESS: {
                    if (DUST_BLACKLIST.contains(entry.getOreName())) break;
                    ModuleStaticPower.addGrinderRecipe("gem" + entry.getOreName(), Utils.getOreStackExtra("dust", entry, 1), 1.0f);
                    break;
                }
                case DUST: {
                    if (ORE_BLACKLIST.contains(entry.getOreName())) break;
                    ModuleStaticPower.addGrinderRecipe("ore" + entry.getOreName(), Utils.getOreStack("dust", entry, 4), 1.0f);
                    break;
                }
            }
        }
    }

    public static void addGrinderRecipe(Object input, List<Pair<ItemStack, Float>> outputs) {
        RegisterHelper.registerGrinderRecipe((Ingredient)Craft.ing((Object)input), (GrinderOutputWrapper.GrinderOutput[])Lists.transform(outputs, pair -> new GrinderOutputWrapper.GrinderOutput((ItemStack)pair.getLeft(), ((Float)pair.getRight()).floatValue())).toArray(new GrinderOutputWrapper.GrinderOutput[outputs.size()]));
    }

    public static void addGrinderRecipe(Object input, ItemStack output, float chance) {
        RegisterHelper.registerGrinderRecipe((Ingredient)Craft.ing((Object)input), (GrinderOutputWrapper.GrinderOutput[])new GrinderOutputWrapper.GrinderOutput[]{new GrinderOutputWrapper.GrinderOutput(output, chance)});
    }

    public static void addFormerRecipe(ItemStack output, Object input, Object mold) {
        RegisterHelper.registerFormerRecipe((ItemStack)output, (Ingredient)Craft.ing((Object)input), (Ingredient)Craft.ing((Object)mold));
    }

    public static void addPlateFormerRecipe(ItemStack output, Object input) {
        ModuleStaticPower.addFormerRecipe(output, input, FormerMolds.moldPlate);
    }

    public static void addWireFormerRecipe(ItemStack output, Object input) {
        ModuleStaticPower.addFormerRecipe(output, input, FormerMolds.moldWire);
    }

    public static void addGearFormerRecipe(ItemStack output, Object input) {
        ModuleStaticPower.addFormerRecipe(output, input, FormerMolds.moldGear);
    }
}

