/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.nbt;

import me.lucko.luckperms.lib.adventure.nbt.BinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.ByteArrayBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.ByteBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.DoubleBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.FloatBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.IntArrayBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.IntBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.LongArrayBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.LongBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.ShortBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.StringBinaryTag;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface CompoundTagSetter<R> {
    public @NonNull R put(@NonNull String var1, @NonNull BinaryTag var2);

    default public @NonNull R putBoolean(@NonNull String key, boolean value) {
        return this.put(key, value ? ByteBinaryTag.ONE : ByteBinaryTag.ZERO);
    }

    default public @NonNull R putByte(@NonNull String key, byte value) {
        return this.put(key, ByteBinaryTag.of(value));
    }

    default public @NonNull R putShort(@NonNull String key, short value) {
        return this.put(key, ShortBinaryTag.of(value));
    }

    default public @NonNull R putInt(@NonNull String key, int value) {
        return this.put(key, IntBinaryTag.of(value));
    }

    default public @NonNull R putLong(@NonNull String key, long value) {
        return this.put(key, LongBinaryTag.of(value));
    }

    default public @NonNull R putFloat(@NonNull String key, float value) {
        return this.put(key, FloatBinaryTag.of(value));
    }

    default public @NonNull R putDouble(@NonNull String key, double value) {
        return this.put(key, DoubleBinaryTag.of(value));
    }

    default public @NonNull R putByteArray(@NonNull String key, byte @NonNull [] value) {
        return this.put(key, ByteArrayBinaryTag.of(value));
    }

    default public @NonNull R putString(@NonNull String key, @NonNull String value) {
        return this.put(key, StringBinaryTag.of(value));
    }

    default public @NonNull R putIntArray(@NonNull String key, int @NonNull [] value) {
        return this.put(key, IntArrayBinaryTag.of(value));
    }

    default public @NonNull R putLongArray(@NonNull String key, long @NonNull [] value) {
        return this.put(key, LongArrayBinaryTag.of(value));
    }
}

