/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import fossilsarcheology.server.api.BlockEntity;
import fossilsarcheology.server.api.IgnoreRenderProperty;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.IBlockItem;
import fossilsarcheology.server.block.entity.TileEntityFigurine;
import fossilsarcheology.server.tab.FATabRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FigurineBlock
extends BlockContainer
implements IBlockItem,
BlockEntity,
IgnoreRenderProperty {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);

    protected FigurineBlock() {
        super(Material.field_151594_q);
        this.func_149647_a(FATabRegistry.BLOCKS);
        this.func_149663_c("figurine");
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.FIGURINE_STEVE_PRISTINE)));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)FABlockRegistry.FIGURINE);
    }

    public IProperty[] getIgnoredProperties() {
        return new IProperty[]{VARIANT};
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 1.5)) & 3;
        worldIn.func_175656_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(stack.func_77960_j()))));
        TileEntity tileentity = worldIn.func_175625_s(pos);
        ((TileEntityFigurine)tileentity).setFigurineType(stack.func_77952_i());
        ((TileEntityFigurine)tileentity).setFigurineRotation(l);
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (EnumType types : EnumType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, types.getMetadata()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFigurine();
    }

    @Override
    public Class<? extends TileEntity> getEntity() {
        return TileEntityFigurine.class;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return true;
    }

    @Override
    public ItemBlock getItemBlock(Block block) {
        return new FigurineBlockItem(block);
    }

    class FigurineBlockItem
    extends ItemBlock {
        public FigurineBlockItem(Block block) {
            super(block);
            this.func_77627_a(true);
        }

        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
            if (this.func_194125_a(tab)) {
                for (int i = 0; i < 16; ++i) {
                    items.add((Object)new ItemStack((Item)this, 1, i));
                }
            }
        }

        public String func_77667_c(ItemStack itemstack) {
            return this.func_77658_a() + "." + EnumType.byMetadata(itemstack.func_77952_i()).func_176610_l();
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        FIGURINE_STEVE_PRISTINE(0, "figurine_steve_pristine"),
        FIGURINE_SKELETON_PRISTINE(1, "figurine_skeleton_pristine"),
        FIGURINE_ZOMBIE_PRISTINE(2, "figurine_zombie_pristine"),
        FIGURINE_PIGZOMBIE_PRISTINE(3, "figurine_pigzombie_pristine"),
        FIGURINE_ENDERMAN_PRISTINE(4, "figurine_enderman_pristine"),
        FIGURINE_STEVE_DAMAGED(5, "figurine_steve_damaged"),
        FIGURINE_SKELETON_DAMAGED(6, "figurine_skeleton_damaged"),
        FIGURINE_ZOMBIE_DAMAGED(7, "figurine_zombie_damaged"),
        FIGURINE_PIGZOMBIE_DAMAGED(8, "figurine_pigzombie_damaged"),
        FIGURINE_ENDERMAN_DAMAGED(9, "figurine_enderman_damaged"),
        FIGURINE_STEVE_BROKEN(10, "figurine_steve_broken"),
        FIGURINE_SKELETON_BROKEN(11, "figurine_skeleton_broken"),
        FIGURINE_ZOMBIE_BROKEN(12, "figurine_zombie_broken"),
        FIGURINE_PIGZOMBIE_BROKEN(13, "figurine_pigzombie_broken"),
        FIGURINE_ENDERMAN_BROKEN(14, "figurine_enderman_broken"),
        FIGURINE_MYSTERIOUS(15, "figurine_mysterious");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private EnumType(int metaIn, String nameIn) {
            this(metaIn, nameIn, nameIn);
        }

        private EnumType(int metaIn, String nameIn, String unlocalizedNameIn) {
            this.meta = metaIn;
            this.name = nameIn;
            this.unlocalizedName = unlocalizedNameIn;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getTranslationKey() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

