/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import fossilsarcheology.Revival;
import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.block.FAFluidRegistry;
import fossilsarcheology.server.entity.monster.EntityTarSlime;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TarBlock
extends BlockFluidClassic {
    public TarBlock() {
        super(FAFluidRegistry.TAR_FLUID, FAFluidRegistry.TAR_MATERIAL);
        this.func_149713_g(1);
        this.func_149663_c("tar");
        this.func_149675_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState neighbor = blockAccess.func_180495_p(pos.func_177972_a(side));
        return neighbor.func_177230_c() != blockState.func_177230_c() || neighbor.func_177230_c() != blockState.func_177230_c() && (neighbor.func_185914_p() || neighbor.func_177230_c() == Blocks.field_150350_a) && (side == EnumFacing.UP || neighbor.func_177230_c() instanceof BlockChest || super.func_176225_a(blockState, blockAccess, pos, side));
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 30;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (world.func_175659_aa() != EnumDifficulty.PEACEFUL && Revival.CONFIG_OPTIONS.spawnTarSlimes && Revival.CONFIG_OPTIONS.tarSlimeSpawnRate > 0 && rand.nextInt(this.isSourceBlock((IBlockAccess)world, pos) ? Revival.CONFIG_OPTIONS.tarSlimeSpawnRate : Revival.CONFIG_OPTIONS.tarSlimeSpawnRate * 15) == 0) {
            double spawnRange = 16.0;
            int k = world.func_72872_a(EntityTarSlime.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)).func_186662_g(spawnRange)).size();
            if (k < 6) {
                EntityTarSlime tarSlime = new EntityTarSlime(world);
                tarSlime.func_180482_a(world.func_175649_E(pos), null);
                tarSlime.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)tarSlime);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(200) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, FASoundRegistry.TAR, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        if (rand.nextInt(3) == 0) {
            float posX = (float)pos.func_177958_n() + rand.nextFloat();
            float posY = (float)pos.func_177956_o() + Math.max(1.0f - BlockLiquid.func_149801_b((int)((Integer)stateIn.func_177229_b((IProperty)LEVEL))), 0.25f);
            float posZ = (float)pos.func_177952_p() + rand.nextFloat();
            double motX = (rand.nextDouble() - 0.5) * 0.3;
            double motY = 0.3 * rand.nextDouble() + 0.2;
            double motZ = (rand.nextDouble() - 0.5) * 0.3;
            Revival.PROXY.spawnFAParticle("tar_bubble", posX, posY, posZ, motX, motY, motZ);
        }
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (((Boolean)this.displacements.get(block)).booleanValue()) {
                block.func_176226_b(world, pos, state, 0);
                return true;
            }
            return false;
        }
        Material material = state.func_185904_a();
        if (material.func_76230_c() || material == Material.field_151586_h || material == Material.field_151567_E) {
            return false;
        }
        int density = TarBlock.getDensity((IBlockAccess)world, (BlockPos)pos);
        if (density == Integer.MAX_VALUE) {
            block.func_176226_b(world, pos, state, 0);
            return true;
        }
        return this.density > density;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityTarSlime) {
            EntityLivingBase living = (EntityLivingBase)entity;
            living.field_70181_x += (double)0.01f;
            living.field_70143_R = 0.0f;
        } else if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            living.field_70159_w *= 0.1;
            living.field_70179_y *= 0.1;
            living.func_70110_aj();
        } else if (entity instanceof EntityItem) {
            entity.field_70181_x *= 0.1;
            entity.field_70159_w *= 0.1;
            entity.field_70179_y *= 0.1;
            if ((int)Math.floor(entity.field_70163_u + 0.875) == pos.func_177956_o()) {
                entity.func_184185_a(SoundEvents.field_187549_bG, 0.4f, 0.6f + world.field_73012_v.nextFloat() * 0.4f);
                entity.func_70106_y();
            }
        }
    }

    public boolean func_176214_u(IBlockState state) {
        return true;
    }
}

