/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.galactic.core.gc;

import asmodeuscore.core.astronomy.BodiesRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import net.minecraft.util.ResourceLocation;
import net.romvoid95.galactic.core.GCTLog;
import net.romvoid95.galactic.core.gc.PlanetGroups;

public class PlanetData {
    private final ResourceLocation IMG = new ResourceLocation("galactictweaks", "textures/gui/galaxy/wormhole.png");
    private final ResourceLocation SUN = new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/sun.png");
    private BodiesRegistry.Galaxies galaxy;
    private SolarSystem system;
    public static Planet FAKE_ASTEROIDS;
    public static Planet FAKE_MARS;
    private List<Planet> epList = PlanetGroups.extraPlanetsGroup().get();
    private List<Planet> gsList = PlanetGroups.galaxySpaceGroup().get();

    public PlanetData() {
        this.galaxy = BodiesRegistry.registerGalaxy((String)"wormhole", (ResourceLocation)this.IMG);
        this.system = new SolarSystem("secondSystem", this.galaxy.getName()).setMapPosition(new Vector3(0.0, 0.0, 0.0));
        Star starSol4 = (Star)new Star("epsystem").setParentSolarSystem(this.system).setTierRequired(-1);
        starSol4.setBodyIcon(this.SUN);
        this.system.setMainStar(starSol4);
        GalaxyRegistry.registerSolarSystem((SolarSystem)this.system);
    }

    public void create(String id) {
        switch (id) {
            case "galaxyspace": {
                this.buildFakePlanets();
                GCTLog.info("" + this.gsList.size());
                ArrayList temp = new ArrayList();
                this.gsList.forEach(p -> {
                    if (p == null) {
                        temp.add(p);
                    }
                });
                if (temp.size() > 0) {
                    this.gsList.removeAll(temp);
                }
                this.gsList.forEach(p -> p.setParentSolarSystem(this.system));
                PlanetGroups.galaxySpaceMoonGroup().forEach(m -> {
                    Planet parent;
                    if (m != null && m.getParentPlanet() != null && (parent = m.getParentPlanet()).getDimensionID() == ConfigManagerMars.dimensionIDMars) {
                        m.setParentPlanet(FAKE_MARS);
                    }
                });
                break;
            }
            case "extraplanets": {
                this.buildFakePlanets();
                this.epList.forEach(p -> p.setParentSolarSystem(this.system));
                PlanetGroups.extraPlanetsMoonGroup().forEach(m -> {
                    Planet parent;
                    if (m != null && m.getParentPlanet() != null && (parent = m.getParentPlanet()).getDimensionID() == ConfigManagerMars.dimensionIDMars) {
                        m.setParentPlanet(FAKE_MARS);
                    }
                });
                break;
            }
        }
    }

    private void buildFakePlanets() {
        Planet OVERWORLD = GalacticraftCore.planetOverworld;
        Planet ASTEROIDS = AsteroidsModule.planetAsteroids;
        Planet MARS = MarsModule.planetMars;
        FAKE_ASTEROIDS = new Planet("fake_asteroids").setParentSolarSystem(this.system);
        FAKE_ASTEROIDS.setRelativeDistanceFromCenter(ASTEROIDS.getRelativeDistanceFromCenter());
        FAKE_ASTEROIDS.setRelativeOrbitTime(45.0f);
        FAKE_ASTEROIDS.setPhaseShift(ASTEROIDS.getPhaseShift());
        FAKE_ASTEROIDS.setRelativeSize(1.0f);
        FAKE_ASTEROIDS.setBodyIcon(ASTEROIDS.getBodyIcon());
        FAKE_ASTEROIDS.setUnreachable();
        GalaxyRegistry.registerPlanet((Planet)FAKE_ASTEROIDS);
        Planet FAKE_OVERWORLD = new Planet("fake_overworld").setParentSolarSystem(this.system);
        FAKE_OVERWORLD.setRelativeDistanceFromCenter(OVERWORLD.getRelativeDistanceFromCenter());
        FAKE_OVERWORLD.setPhaseShift(OVERWORLD.getPhaseShift());
        FAKE_OVERWORLD.setRelativeSize(1.0f);
        FAKE_OVERWORLD.setBodyIcon(OVERWORLD.getBodyIcon());
        FAKE_OVERWORLD.atmosphere.composition.addAll(Arrays.asList(EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.ARGON, EnumAtmosphericGas.WATER));
        FAKE_OVERWORLD.setUnreachable();
        GalaxyRegistry.registerPlanet((Planet)FAKE_OVERWORLD);
        FAKE_MARS = new Planet("fake_mars").setParentSolarSystem(this.system);
        FAKE_MARS.setRelativeDistanceFromCenter(MARS.getRelativeDistanceFromCenter());
        FAKE_MARS.setRelativeOrbitTime(MARS.getRelativeOrbitTime());
        FAKE_MARS.setPhaseShift(MARS.getPhaseShift());
        FAKE_MARS.setRelativeSize(1.0f);
        FAKE_MARS.setBodyIcon(MARS.getBodyIcon());
        PlanetData.FAKE_MARS.atmosphere.composition.addAll(Arrays.asList(EnumAtmosphericGas.CO2, EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.ARGON));
        FAKE_MARS.setUnreachable();
        GalaxyRegistry.registerPlanet((Planet)FAKE_MARS);
    }
}

