/*
 * Decompiled with CFR 0.152.
 */
package de.randombyte.lottery.commands;

import de.randombyte.lottery.Config;
import de.randombyte.lottery.LotteryKt;
import de.randombyte.lottery.shaded.kosp.PlayerExecutedCommand;
import de.randombyte.lottery.shaded.kosp.config.ConfigManager;
import de.randombyte.lottery.shaded.kosp.extensions.StringsKt;
import de.randombyte.lottery.shaded.kotlin.Metadata;
import de.randombyte.lottery.shaded.kotlin.TuplesKt;
import de.randombyte.lottery.shaded.kotlin.collections.MapsKt;
import de.randombyte.lottery.shaded.kotlin.jvm.internal.Intrinsics;
import java.math.BigDecimal;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lde/randombyte/lottery/commands/BuyTicketCommand;", "Lde/randombyte/lottery/shaded/kosp/PlayerExecutedCommand;", "configManager", "Lde/randombyte/lottery/shaded/kosp/config/ConfigManager;", "Lde/randombyte/lottery/Config;", "transactionCause", "Lorg/spongepowered/api/event/cause/Cause;", "(Lde/randombyte/kosp/config/ConfigManager;Lorg/spongepowered/api/event/cause/Cause;)V", "getConfigManager", "()Lde/randombyte/kosp/config/ConfigManager;", "getTransactionCause", "()Lorg/spongepowered/api/event/cause/Cause;", "executedByPlayer", "Lorg/spongepowered/api/command/CommandResult;", "player", "Lorg/spongepowered/api/entity/living/player/Player;", "args", "Lorg/spongepowered/api/command/args/CommandContext;", "lottery"})
public final class BuyTicketCommand
extends PlayerExecutedCommand {
    @NotNull
    private final ConfigManager<Config> configManager;
    @NotNull
    private final Cause transactionCause;

    @Override
    @NotNull
    public CommandResult executedByPlayer(@NotNull Player player, @NotNull CommandContext args) {
        TransactionResult transactionResult;
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Config config = this.configManager.get();
        int boughtTickets = config.getInternalData().getBoughtTickets(player);
        Integer amount = args.getOne("ticketAmount").orElse(1);
        if (Intrinsics.compare(amount, 1) < 0) {
            throw (Throwable)new CommandException(StringsKt.red("'ticketAmount' must be positive!"));
        }
        int n = config.getTicketCosts();
        Integer n2 = amount;
        Intrinsics.checkExpressionValueIsNotNull(n2, "amount");
        int ticketCosts = n * n2;
        int finalBoughtTickets = boughtTickets + amount;
        if (config.getMaxTickets() < finalBoughtTickets) {
            LiteralText.Builder errorTextBuilder = Text.builder((String)"Maximum tickets per player reached!");
            int ticketsAvailableForBuy = config.getMaxTickets() - boughtTickets;
            if (ticketsAvailableForBuy > 0) {
                errorTextBuilder.append(new Text[]{(Text)Text.of((String)(" You can only buy " + ticketsAvailableForBuy + " more ticket(s)!"))});
            }
            throw (Throwable)new CommandException((Text)errorTextBuilder.build());
        }
        Config newConfig = Config.copy$default(config, null, 0, 0, 0, 0, null, config.getInternalData().copy(MapsKt.plus(config.getInternalData().getBoughtTickets(), TuplesKt.to(player.getUniqueId(), finalBoughtTickets)), config.getInternalData().getPot() + ticketCosts), null, 191, null);
        EconomyService economyService = LotteryKt.getEconomyServiceOrFail();
        UniqueAccount account = (UniqueAccount)economyService.getOrCreateAccount(player.getUniqueId()).get();
        BigDecimal costs = new BigDecimal(ticketCosts);
        if (account.getBalance(economyService.getDefaultCurrency()).compareTo(costs) < 0) {
            throw (Throwable)new CommandException(config.getMessages().getNotEnoughMoney());
        }
        TransactionResult transactionResult2 = transactionResult = account.withdraw(economyService.getDefaultCurrency(), costs, this.transactionCause);
        Intrinsics.checkExpressionValueIsNotNull(transactionResult2, "transactionResult");
        if (Intrinsics.areEqual(transactionResult2.getResult(), ResultType.SUCCESS) ^ true) {
            throw (Throwable)new CommandException(StringsKt.red("Transaction failed!"));
        }
        this.configManager.save(newConfig);
        Text buyMessage = config.getMessages().getBuyTicketMessage().apply(MapsKt.mapOf(TuplesKt.to("boughtTickets", amount), TuplesKt.to("totalTickets", finalBoughtTickets))).build();
        player.sendMessage(buyMessage);
        if (config.getBroadcasts().getBroadcastTicketPurchase()) {
            Text broadcastText;
            Text text = broadcastText = config.getMessages().getBuyTicketBroadcast().apply(MapsKt.mapOf(TuplesKt.to("buyerName", player.getName()), TuplesKt.to("ticketAmount", amount), TuplesKt.to("pot", config.calculatePot()))).build();
            Intrinsics.checkExpressionValueIsNotNull(text, "broadcastText");
            LotteryKt.broadcast(text);
        }
        CommandResult commandResult = CommandResult.success();
        Intrinsics.checkExpressionValueIsNotNull(commandResult, "CommandResult.success()");
        return commandResult;
    }

    @NotNull
    public final ConfigManager<Config> getConfigManager() {
        return this.configManager;
    }

    @NotNull
    public final Cause getTransactionCause() {
        return this.transactionCause;
    }

    public BuyTicketCommand(@NotNull ConfigManager<Config> configManager, @NotNull Cause transactionCause) {
        Intrinsics.checkParameterIsNotNull(configManager, "configManager");
        Intrinsics.checkParameterIsNotNull(transactionCause, "transactionCause");
        this.configManager = configManager;
        this.transactionCause = transactionCause;
    }
}

