/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client;

import io.github.phantamanta44.libnine.Registrar;
import io.github.phantamanta44.libnine.Virtue;
import io.github.phantamanta44.libnine.block.L9Block;
import io.github.phantamanta44.libnine.block.L9BlockStated;
import io.github.phantamanta44.libnine.block.state.IBlockModelMapper;
import io.github.phantamanta44.libnine.gui.GuiIdentity;
import io.github.phantamanta44.libnine.gui.L9GuiHandler;
import io.github.phantamanta44.libnine.item.L9Item;
import io.github.phantamanta44.libnine.util.tuple.IPair;
import io.github.phantamanta44.libnine.util.tuple.ITriple;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientRegistrar
extends Registrar {
    private final List<ITriple<Item, Integer, ModelResourceLocation>> rqItemModels = new LinkedList<ITriple<Item, Integer, ModelResourceLocation>>();
    private final List<IPair<Block, IStateMapper>> rqBlockStateMappers = new LinkedList<IPair<Block, IStateMapper>>();
    private final List<IPair<IItemColor, Item[]>> rqItemColourHandlers = new LinkedList<IPair<IItemColor, Item[]>>();
    private final List<IPair<IBlockColor, L9Block[]>> rqBlockColourHandlers = new LinkedList<IPair<IBlockColor, L9Block[]>>();

    @Override
    public void queueItemModelReg(L9Item item, int meta, String model, String variant) {
        this.rqItemModels.add(ITriple.of(item, meta, this.getBound().newModelResourceLocation(model, variant)));
    }

    @Override
    public void queueItemModelReg(L9Item item, int meta, String model) {
        this.queueItemModelReg(item, meta, model, "inventory");
    }

    @Override
    public void queueItemModelReg(L9Item item, String model) {
        this.queueItemModelReg(item, 0, model);
    }

    @Override
    public void queueItemBlockModelReg(L9Block block, int meta, String model, String variant) {
        this.rqItemModels.add(ITriple.of(block.getItemBlock(), meta, this.getBound().newModelResourceLocation(model, variant)));
    }

    @Override
    public void queueItemBlockModelReg(L9Block block, int meta, String model) {
        this.queueItemBlockModelReg(block, meta, model, "inventory");
    }

    @Override
    public void queueItemBlockModelReg(L9Block block, String model) {
        this.queueItemBlockModelReg(block, 0, model);
    }

    @Override
    public void queueBlockStateMapperReg(L9BlockStated block, IBlockModelMapper mapper) {
        this.rqBlockStateMappers.add(IPair.of(block, new StateMapperAdapter(mapper, this.getBound())));
    }

    @Override
    public void queueItemColourHandlerReg(IItemColor handler, Item ... items) {
        this.rqItemColourHandlers.add(IPair.of(handler, items));
    }

    @Override
    public void queueBlockColourHandlerReg(IBlockColor handler, L9Block ... blocks) {
        this.rqBlockColourHandlers.add(IPair.of(handler, blocks));
    }

    @Override
    public void onRegisterColourHandlers() {
        this.rqItemColourHandlers.forEach(h -> h.sprexec((arg_0, arg_1) -> ((ItemColors)Minecraft.func_71410_x().getItemColors()).func_186730_a(arg_0, arg_1)));
        this.rqBlockColourHandlers.forEach(h -> h.sprexec((arg_0, arg_1) -> ((BlockColors)Minecraft.func_71410_x().func_184125_al()).func_186722_a(arg_0, arg_1)));
    }

    @Override
    public <T extends TileEntity> void queueTESRReg(Class<T> clazz, TileEntitySpecialRenderer<T> renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(clazz, renderer);
    }

    @Override
    public <S extends Container, C> void queueGuiClientReg(GuiIdentity<S, C> identity, L9GuiHandler.IGuiFactory<S, C> factory) {
        this.getBound().getGuiHandler().registerClientGui(identity, factory);
    }

    @Override
    protected void hookEvents() {
        super.hookEvents();
        MinecraftForge.EVENT_BUS.register((Object)new ClientRegistrarHook());
    }

    private static class StateMapperAdapter
    extends StateMapperBase {
        private final IBlockModelMapper mapper;
        private final Virtue virtue;

        StateMapperAdapter(IBlockModelMapper mapper, Virtue virtue) {
            this.mapper = mapper;
            this.virtue = virtue;
        }

        public Map<IBlockState, ModelResourceLocation> func_178130_a(Block block) {
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                this.field_178133_b.put(state, this.func_178132_a(state));
            }
            return this.field_178133_b;
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            String model = this.mapper.getModel(state);
            String variant = this.mapper.getVariant(state);
            return variant == null ? this.virtue.newModelResourceLocation(model) : this.virtue.newModelResourceLocation(model, variant);
        }
    }

    private class ClientRegistrarHook {
        private ClientRegistrarHook() {
        }

        @SubscribeEvent
        public void onRegisterModels(ModelRegistryEvent event) {
            ClientRegistrar.this.rqItemModels.forEach(m -> m.sprexec(ModelLoader::setCustomModelResourceLocation));
            ClientRegistrar.this.rqBlockStateMappers.forEach(m -> m.sprexec(ModelLoader::setCustomStateMapper));
        }
    }
}

