/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.bqforestry.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import com.nicjames2378.bqforestry.BQ_Forestry;
import com.nicjames2378.bqforestry.client.gui.editors.tasks.GuiEditTaskKeyCode;
import com.nicjames2378.bqforestry.client.tasks.PanelTaskKeyCode;
import com.nicjames2378.bqforestry.config.ConfigHandler;
import com.nicjames2378.bqforestry.tasks.factory.FactoryTaskKeyCode;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.Level;

public class TaskKeyCode
implements ITask {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    public String keyCode = TaskKeyCode.generateRandomString(8, true, true);
    public String inputCode = "";
    public boolean caseSensitive = ConfigHandler.cfgCaseSensitiveKeyCodes;

    private static String generateRandomString(int length, boolean allowLetters, boolean allowNumbers) {
        return RandomStringUtils.random((int)length, (boolean)allowLetters, (boolean)allowNumbers);
    }

    public String getUnlocalisedName() {
        return "bqforestry.task.keycode";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskKeyCode.INSTANCE.getRegistryName();
    }

    public void detect(ParticipantInfo participant, DBEntry<IQuest> quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)participant.PLAYER);
        if (this.isComplete(playerID)) {
            return;
        }
        if (this.caseSensitive) {
            if (this.inputCode.equals(this.keyCode)) {
                this.setComplete(playerID);
            }
        } else if (this.inputCode.equalsIgnoreCase(this.keyCode)) {
            this.setComplete(playerID);
        }
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74778_a("keycode", this.keyCode);
        json.func_74757_a("caseSensitive", this.caseSensitive);
        return json;
    }

    public void readFromNBT(NBTTagCompound json) {
        this.keyCode = json.func_74779_i("keycode");
        this.caseSensitive = json.func_74767_n("caseSensitive");
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Forestry.log.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        return nbt;
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
        } else {
            this.completeUsers.remove(uuid);
        }
    }

    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskKeyCode(rect, (IQuest)quest.getValue(), this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return new GuiEditTaskKeyCode(parent, quest, this);
    }
}

