/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.bqforestry.utils;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.utils.QuestTranslation;
import com.nicjames2378.bqforestry.BQ_Forestry;
import com.nicjames2378.bqforestry.config.ConfigHandler;
import com.nicjames2378.bqforestry.utils.StringUtils;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosomeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import net.bdew.gendustry.custom.BeeSpecies;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;

public class UtilitiesBee {
    public static final String DEFAULT_SPECIES = "forestry.speciesCommon";
    public static final String _INVALID_SPECIES_STRING = "(MISSING) ";
    private static String[] cacheGrowthStages;

    public static void initialize() {
        for (EnumBeeChromosome chromosome : EnumBeeChromosome.values()) {
            TreeMap<Integer, String> orderedMap = UtilitiesBee.getAllelesForChromosome(chromosome);
            int counter = 0;
            for (Map.Entry<Integer, String> entry : UtilitiesBee.getAllelesForChromosome(chromosome).entrySet()) {
                BQ_Forestry.debug(String.format("%1$s %2$d / %3$d found: %4$s (%5$s)", chromosome.toString(), counter + 1, orderedMap.size(), entry.getValue(), entry.getKey()));
            }
        }
    }

    public static String getDisplayName(ItemStack stack) {
        String speciesTrait = UtilitiesBee.getTrait(stack, EnumBeeChromosome.SPECIES, true)[0];
        return UtilitiesBee.checkTraitIsInDatabase(EnumBeeChromosome.SPECIES, speciesTrait) ? stack.func_82833_r() : TextFormatting.RED + _INVALID_SPECIES_STRING + speciesTrait;
    }

    public static TreeMap<Integer, String> getAllelesForChromosome(EnumBeeChromosome chromosome) {
        Collection alleles = AlleleManager.alleleRegistry.getRegisteredAlleles((IChromosomeType)chromosome);
        TreeMap<Integer, String> orderedMap = new TreeMap<Integer, String>();
        Iterator iterator = alleles.iterator();
        int counter = 0;
        for (int i = 0; i < alleles.size(); ++i) {
            String value;
            Object next = iterator.next();
            if (BQ_Forestry.hasGendustry && next.getClass().equals(BeeSpecies.class)) {
                BeeSpecies gendustryBeeSpecies = (BeeSpecies)next;
                value = gendustryBeeSpecies.getUID();
            } else {
                value = next.toString();
            }
            int position = UtilitiesBee.getPosition(chromosome.getAlleleClass(), next);
            if (position < 0) {
                counter = (short)(counter + 1);
            }
            orderedMap.put(position >= 0 ? position : i, value);
        }
        if (counter >= 2) {
            TreeMap<Integer, String> newOrder = new TreeMap<Integer, String>();
            TreeSet<String> set = new TreeSet<String>(orderedMap.values());
            Iterator iter = set.iterator();
            for (int i = 0; i < set.size(); ++i) {
                newOrder.put(i, (String)iter.next());
            }
            return newOrder;
        }
        return orderedMap;
    }

    private static int getPosition(Class<? extends IAllele> alleleClass, Object item) {
        if (IAlleleInteger.class.isAssignableFrom(alleleClass)) {
            IAlleleInteger aa = (IAlleleInteger)item;
            return aa.getValue();
        }
        if (IAlleleFloat.class.isAssignableFrom(alleleClass)) {
            IAlleleFloat aa = (IAlleleFloat)item;
            return (int)(aa.getValue() * 10.0f);
        }
        if (IAlleleBoolean.class.isAssignableFrom(alleleClass)) {
            IAlleleBoolean aa = (IAlleleBoolean)item;
            return aa.getValue() ? 1 : 0;
        }
        if (IAlleleTolerance.class.isAssignableFrom(alleleClass)) {
            IAlleleTolerance aa = (IAlleleTolerance)item;
            String[] val = String.valueOf(aa.getValue()).toLowerCase().split("_");
            if (val[0].contains("down")) {
                return 10 + Integer.parseInt(val[1]);
            }
            if (val[0].contains("up")) {
                return 20 + Integer.parseInt(val[1]);
            }
            if (val[0].contains("both")) {
                return 30 + Integer.parseInt(val[1]);
            }
            return 0;
        }
        if (IAlleleArea.class.isAssignableFrom(alleleClass)) {
            IAlleleArea aa = (IAlleleArea)item;
            Vec3i vec = aa.getValue();
            return vec.func_177958_n() + vec.func_177956_o() + vec.func_177952_p();
        }
        return -1;
    }

    private static String getGrowthPath(BeeTypes type) {
        return String.format("bee_%1$s_ge", type.get());
    }

    public static String[] getGrowthStages() {
        if (cacheGrowthStages != null) {
            return cacheGrowthStages;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (BeeTypes a : BeeTypes.values()) {
            list.add(a.get());
        }
        cacheGrowthStages = list.toArray(new String[0]);
        return cacheGrowthStages;
    }

    public static ItemStack getBaseBee(String species) {
        return UtilitiesBee.getBaseBee(species, BeeTypes.valueOf(ConfigHandler.cfgBeeType), false);
    }

    public static ItemStack getBaseBee(String species, BeeTypes beeType) {
        return UtilitiesBee.getBaseBee(species, beeType, false);
    }

    public static ItemStack getBaseBee(String species, BeeTypes beeType, boolean requireMated) {
        if (species == null) {
            species = DEFAULT_SPECIES;
        }
        ResourceLocation rl = new ResourceLocation("forestry", UtilitiesBee.getGrowthPath(beeType));
        ItemStack bee = new ItemStack((Item)Objects.requireNonNull(Item.field_150901_e.func_82594_a((Object)rl)));
        NBTTagCompound speciesTag = new NBTTagCompound();
        speciesTag.func_74774_a("Slot", (byte)0);
        speciesTag.func_74778_a("UID0", species);
        speciesTag.func_74778_a("UID1", species);
        NBTTagList chromosomes = new NBTTagList();
        chromosomes.func_74742_a((NBTBase)speciesTag);
        NBTTagCompound genome = new NBTTagCompound();
        genome.func_74782_a("Chromosomes", (NBTBase)chromosomes);
        NBTTagCompound itemData = new NBTTagCompound();
        itemData.func_74782_a("Genome", (NBTBase)genome);
        UtilitiesBee.setMated(bee, requireMated);
        bee.func_77982_d(itemData);
        return bee;
    }

    public static BigItemStack getSafeStack(BigItemStack stack) {
        BigItemStack safeStack = stack.copy();
        String stackDName = UtilitiesBee.getDisplayName(safeStack.getBaseStack());
        if (stackDName.contains(_INVALID_SPECIES_STRING)) {
            safeStack.getBaseStack().func_77982_d(UtilitiesBee.getBaseBee(DEFAULT_SPECIES).func_77978_p());
            safeStack.getBaseStack().func_151001_c(stackDName);
        }
        return safeStack;
    }

    public static void setMated(ItemStack bee, boolean isMated) {
        if (bee == null) {
            throw new NullPointerException();
        }
        NBTTagCompound tag = bee.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (isMated) {
            tag.func_74782_a("Mate", (NBTBase)new NBTTagCompound());
        } else if (tag.func_74764_b("Mate")) {
            tag.func_82580_o("Mate");
        }
    }

    public static HashMap<EnumBeeChromosome, HashSet<String>> getAllTraits(ItemStack bee, boolean forceForestryMethod) {
        HashMap<EnumBeeChromosome, HashSet<String>> retMap = new HashMap<EnumBeeChromosome, HashSet<String>>();
        for (EnumBeeChromosome chromosome : EnumBeeChromosome.values()) {
            HashSet set = new HashSet();
            String[] array = UtilitiesBee.getTrait(bee, chromosome, forceForestryMethod);
            if (array.length <= 0 || array[0].equals("")) continue;
            Collections.addAll(set, array);
            retMap.put(chromosome, set);
        }
        return retMap;
    }

    public static String[] getTrait(ItemStack bee, EnumBeeChromosome chromosome, boolean forceForestryMethod) {
        String[] ret;
        String[] _EMPTY = new String[]{""};
        if (bee == null) {
            return _EMPTY;
        }
        if (!bee.func_77942_o()) {
            return _EMPTY;
        }
        NBTTagCompound tag = bee.func_77978_p();
        if (!tag.func_74764_b("Genome")) {
            return _EMPTY;
        }
        NBTTagCompound tagGenome = tag.func_74775_l("Genome");
        if (tagGenome.func_82582_d()) {
            return _EMPTY;
        }
        if (chromosome == EnumBeeChromosome.SPECIES || forceForestryMethod) {
            NBTTagList tagStupidSpeciesIsStupid = tagGenome.func_150295_c("Chromosomes", 10);
            if (tagStupidSpeciesIsStupid.func_82582_d()) {
                return _EMPTY;
            }
            NBTTagCompound tagTrait = (NBTTagCompound)tagStupidSpeciesIsStupid.func_179238_g(UtilitiesBee.getIndexFromChromosome(chromosome));
            ret = new String[]{tagTrait.func_74779_i("UID0")};
        } else {
            NBTTagCompound tagChromosomesList = tagGenome.func_74775_l("ChromosomesList");
            NBTTagList nbtTraitList = tagChromosomesList.func_150295_c(chromosome.getName(), 8);
            ArrayList<String> returnValue = new ArrayList<String>();
            for (int i = 0; i < nbtTraitList.func_74745_c(); ++i) {
                returnValue.add(nbtTraitList.func_150307_f(i));
            }
            ret = returnValue.size() <= 0 ? _EMPTY : returnValue.toArray(new String[0]);
        }
        return ret;
    }

    public static void clearTraits(ItemStack bee, EnumBeeChromosome chromosome) {
        if (bee == null) {
            throw new NullPointerException();
        }
        NBTTagCompound tag = bee.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        NBTTagCompound tagGenome = tag.func_74775_l("Genome");
        if (chromosome == EnumBeeChromosome.SPECIES) {
            UtilitiesBee.writeTrait(bee, chromosome, DEFAULT_SPECIES);
        } else {
            NBTTagCompound tagChromosomesList;
            if (!tagGenome.func_74764_b("ChromosomesList")) {
                tagGenome.func_74782_a("ChromosomesList", (NBTBase)new NBTTagCompound());
            }
            if (!(tagChromosomesList = tagGenome.func_74775_l("ChromosomesList")).func_74764_b(chromosome.getName())) {
                tagChromosomesList.func_74782_a(chromosome.getName(), (NBTBase)new NBTTagList());
            }
            NBTTagList nbtTraitList = tagChromosomesList.func_150295_c(chromosome.getName(), 8);
            int a = nbtTraitList.func_74745_c();
            for (int i = 0; i < a; ++i) {
                nbtTraitList.func_74744_a(0);
            }
        }
    }

    public static void writeTrait(ItemStack bee, EnumBeeChromosome chromosome, String trait) {
        if (bee == null) {
            throw new NullPointerException();
        }
        NBTTagCompound tag = bee.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        NBTTagCompound tagGenome = tag.func_74775_l("Genome");
        if (chromosome == EnumBeeChromosome.SPECIES) {
            NBTTagList tagStupidSpeciesIsStupid = tagGenome.func_150295_c("Chromosomes", 10);
            NBTTagCompound tagTrait = (NBTTagCompound)tagStupidSpeciesIsStupid.func_179238_g(0);
            tagTrait.func_74778_a("UID0", trait);
            tagTrait.func_74778_a("UID1", trait);
        } else {
            NBTTagCompound tagChromosomesList;
            if (!tagGenome.func_74764_b("ChromosomesList")) {
                tagGenome.func_74782_a("ChromosomesList", (NBTBase)new NBTTagCompound());
            }
            if (!(tagChromosomesList = tagGenome.func_74775_l("ChromosomesList")).func_74764_b(chromosome.getName())) {
                tagChromosomesList.func_74782_a(chromosome.getName(), (NBTBase)new NBTTagList());
            }
            NBTTagList nbtTraitList = tagChromosomesList.func_150295_c(chromosome.getName(), 8);
            NBTTagString str = new NBTTagString(trait);
            boolean doWrite = true;
            for (int i = 0; i < nbtTraitList.func_74745_c(); ++i) {
                if (!nbtTraitList.func_179238_g(i).equals((Object)str)) continue;
                doWrite = false;
            }
            if (doWrite) {
                nbtTraitList.func_74742_a((NBTBase)new NBTTagString(trait));
            }
        }
    }

    private static int getIndexFromChromosome(EnumBeeChromosome chromosome) {
        switch (chromosome) {
            case SPECIES: {
                return 0;
            }
            case SPEED: {
                return 1;
            }
            case LIFESPAN: {
                return 2;
            }
            case FERTILITY: {
                return 3;
            }
            case TEMPERATURE_TOLERANCE: {
                return 4;
            }
            case NEVER_SLEEPS: {
                return 5;
            }
            case HUMIDITY_TOLERANCE: {
                return 6;
            }
            case TOLERATES_RAIN: {
                return 7;
            }
            case CAVE_DWELLING: {
                return 8;
            }
            case FLOWER_PROVIDER: {
                return 9;
            }
            case FLOWERING: {
                return 10;
            }
            case TERRITORY: {
                return 11;
            }
            case EFFECT: {
                return 12;
            }
        }
        return -1;
    }

    public static BeeTypes getGrowthLevel(ItemStack bee) {
        for (String s : UtilitiesBee.getGrowthStages()) {
            if (!bee.func_77977_a().contains(s)) continue;
            return BeeTypes.valueOf(s);
        }
        return BeeTypes.valueOf(ConfigHandler.cfgBeeType);
    }

    public static boolean hasValidGrowthLevel(ItemStack bee) {
        for (String s : UtilitiesBee.getGrowthStages()) {
            if (!bee.func_77977_a().contains(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMated(ItemStack item) {
        return item.func_77942_o() && item.func_77978_p().func_74764_b("Mate");
    }

    public static boolean checkTraitsMatch(ItemStack rStack, ItemStack invStack, EnumBeeChromosome trait) {
        return Arrays.equals(UtilitiesBee.getTrait(rStack, trait, false), UtilitiesBee.getTrait(invStack, trait, false));
    }

    public static boolean checkTraitIsInDatabase(EnumBeeChromosome chromosome, String trait) {
        for (Map.Entry<Integer, String> entry : UtilitiesBee.getAllelesForChromosome(chromosome).entrySet()) {
            if (!trait.equals(entry.getValue())) continue;
            return true;
        }
        BQ_Forestry.debug(String.format("DATABASE_ERR: Allele %1$s is NOT in database for %2$s!", trait, chromosome.toString()));
        return false;
    }

    public static ArrayList<String> getBeeInfo(ItemStack bee) {
        ArrayList<String> info = new ArrayList<String>();
        info.add(UtilitiesBee.getInfoString("bqforestry.label.bee.species", bee, EnumBeeChromosome.SPECIES));
        info.add(UtilitiesBee.getInfoString("bqforestry.label.bee.lifespan", bee, EnumBeeChromosome.LIFESPAN));
        info.add(UtilitiesBee.getInfoString("bqforestry.label.bee.speeds", bee, EnumBeeChromosome.SPEED));
        info.add(UtilitiesBee.getInfoString("bqforestry.label.bee.flowering", bee, EnumBeeChromosome.FLOWERING));
        info.add(UtilitiesBee.getInfoString("bqforestry.label.bee.fertility", bee, EnumBeeChromosome.FERTILITY));
        info.add(UtilitiesBee.getInfoString("bqforestry.label.bee.territory", bee, EnumBeeChromosome.TERRITORY));
        info.add(UtilitiesBee.getInfoString("bqforestry.label.bee.effect", bee, EnumBeeChromosome.EFFECT));
        info.add(UtilitiesBee.getInfoString("bqforestry.label.bee.temp", bee, EnumBeeChromosome.TEMPERATURE_TOLERANCE));
        info.add(UtilitiesBee.getInfoString("bqforestry.label.bee.humidity", bee, EnumBeeChromosome.HUMIDITY_TOLERANCE));
        info.add(UtilitiesBee.getInfoString("bqforestry.label.bee.sleeps", bee, EnumBeeChromosome.NEVER_SLEEPS));
        info.add(UtilitiesBee.getInfoString("bqforestry.label.bee.rain", bee, EnumBeeChromosome.TOLERATES_RAIN));
        info.add(UtilitiesBee.getInfoString("bqforestry.label.bee.dwelling", bee, EnumBeeChromosome.CAVE_DWELLING));
        info.add(UtilitiesBee.getInfoString("bqforestry.label.bee.flowers", bee, EnumBeeChromosome.FLOWER_PROVIDER));
        return info;
    }

    private static String getInfoString(String translationKey, ItemStack bee, EnumBeeChromosome chromosome) {
        String GOLD = TextFormatting.GOLD.toString();
        String AQUA = TextFormatting.AQUA.toString();
        String DIV = GOLD.concat(", ").concat(AQUA);
        StringUtils.IStringStyle style = str -> str.substring(StringUtils.indexOfFirstCapital(str));
        String ret = GOLD.concat(QuestTranslation.translate((String)translationKey, (Object[])new Object[0])).concat(": ").concat(AQUA);
        if (chromosome == EnumBeeChromosome.SPECIES) {
            return ret.concat(UtilitiesBee.getDisplayName(bee)).concat(" (" + UtilitiesBee.getTrait(bee, chromosome, true)[0]) + ")";
        }
        return ret.concat(StringUtils.flattenArray(UtilitiesBee.getTrait(bee, chromosome, false), DIV, style));
    }

    public static void listAllSpecies() {
        BQ_Forestry.log.info("Config ListAllBees is TRUE. Outputting bees list now.");
        BQ_Forestry.log.info("===========================================================");
        Collection species = AlleleManager.alleleRegistry.getRegisteredAlleles((IChromosomeType)EnumBeeChromosome.SPECIES);
        Iterator a = species.iterator();
        for (int i = 0; i < species.size(); ++i) {
            String spe = a.next().toString();
            BQ_Forestry.log.info(String.format("Bees species found: %1$d / %2$d - %3$s", i + 1, species.size(), spe));
        }
        BQ_Forestry.log.info("===========================================================");
    }

    public static enum BeeTypes {
        larvae("larvae"),
        drone("drone"),
        princess("princess"),
        queen("queen");

        private final String text;

        private BeeTypes(String text) {
            this.text = text;
        }

        public String get() {
            return this.text;
        }
    }
}

