/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import ic2.core.IC2;
import ic2.core.network.buffers.InputBuffer;
import ic2.core.network.buffers.OutputBuffer;
import ic2.core.network.packets.IC2Packet;
import ic2.core.platform.config.ConfigEntry;
import ic2.core.platform.config.IC2Config;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Lang;
import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class LoginPacket
extends IC2Packet {
    IC2Config config = IC2.config;
    int messageType = 0;

    @Override
    public void read(ByteBuf par1) {
        InputBuffer buffer = new InputBuffer(par1);
        int expected = buffer.readInt();
        Map<String, ConfigEntry> map = this.config.getConfigMap();
        for (int i = 0; i < expected; ++i) {
            ConfigEntry entry = map.get(buffer.readString());
            this.messageType = Math.max(this.messageType, entry.readValue(buffer, this.config));
        }
    }

    @Override
    public void write(ByteBuf par1) {
        LinkedHashMap<String, ConfigEntry> toSend = new LinkedHashMap<String, ConfigEntry>();
        for (Map.Entry<String, ConfigEntry> entry : this.config.getConfigMap().entrySet()) {
            if (!entry.getValue().isSynchronized()) continue;
            toSend.put(entry.getKey(), entry.getValue());
        }
        OutputBuffer buffer = new OutputBuffer(par1);
        buffer.writeInt(toSend.size());
        for (Map.Entry entry : toSend.entrySet()) {
            buffer.writeString((String)entry.getKey());
            ((ConfigEntry)entry.getValue()).writeValue(buffer, this.config);
        }
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        IC2.network.get().sendLoginData();
        PlayerHandler handler = PlayerHandler.getHandlerForPlayer(par1);
        IC2Config config = IC2.config;
        handler.quantumArmorBoostSprint = config.getFlag("QuantumSpeedOnSprint");
        handler.windEffectsElytra = config.getFlag("ElytraClient");
        if (this.messageType > 0) {
            IC2.platform.messagePlayer(par1, this.getMessage());
        }
    }

    public LocaleComp getMessage() {
        if (this.messageType == 2) {
            return Ic2Lang.configUpdatedWorld;
        }
        if (this.messageType == 3) {
            return Ic2Lang.configUpdatedGame;
        }
        return Ic2Lang.configUpdated;
    }
}

