/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network.packets;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import reborncore.RebornCore;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.gui.builder.GuiBase;

public class VariableMessage
implements IMessage {
    private Type type;
    private int dimension;
    private BlockPos pos;
    private NBTTagCompound tag;

    public VariableMessage() {
    }

    public VariableMessage(Type type, int dimension, BlockPos pos, NBTTagCompound tag) {
        this.type = type;
        this.dimension = dimension;
        this.pos = pos;
        this.tag = tag;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.type = Type.values()[buf.readInt()];
            this.dimension = buf.readInt();
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            short length = buf.readShort();
            if (length < 0) {
                this.tag = new NBTTagCompound();
            } else {
                byte[] bytes = new byte[length];
                buf.readBytes(bytes);
                ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
                this.tag = CompressedStreamTools.func_74796_a((InputStream)byteStream);
            }
        }
        catch (IOException exception) {
            RebornCore.logHelper.fatal(exception);
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            buf.writeInt(this.type.ordinal());
            buf.writeInt(this.dimension);
            buf.writeLong(this.pos.func_177986_g());
            if (this.tag == null || this.tag.func_186856_d() == 0) {
                buf.writeShort(-1);
            } else {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.tag, (OutputStream)byteStream);
                byte[] bytes = byteStream.toByteArray();
                buf.writeShort((int)((short)bytes.length));
                buf.writeBytes(bytes);
            }
        }
        catch (IOException exception) {
            RebornCore.logHelper.fatal(exception);
        }
    }

    public static class VariableMessageHandler
    implements IMessageHandler<VariableMessage, VariableMessage> {
        public VariableMessage onMessage(VariableMessage message, MessageContext context) {
            if (message == null) {
                return null;
            }
            if (message.type == null) {
                return null;
            }
            switch (message.type) {
                case TILE: {
                    break;
                }
                case GUI: {
                    this.handleGuiMessage(message, context);
                }
            }
            return null;
        }

        public VariableMessage handleGuiMessage(VariableMessage message, MessageContext context) {
            BuiltContainer container;
            if (message.pos == null || message.tag == null) {
                return null;
            }
            if (context.side.isServer()) {
                throw new RuntimeException("Message of Type GUI cannot be processed on the server");
            }
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui instanceof GuiBase && (container = ((GuiBase)gui).container) != null) {
                container.handleGuiMessage(message.tag);
            }
            return null;
        }
    }

    public static enum Type {
        TILE,
        GUI;

    }
}

