/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class RebornTransformer
implements IClassTransformer {
    List<ClassTransformer> classTransformers = new ArrayList<ClassTransformer>();

    public ClassTransformer transformClass(String className) {
        ClassTransformer classTransformer = new ClassTransformer(className);
        this.classTransformers.add(classTransformer);
        return classTransformer;
    }

    public List<ClassTransformer> getTransformers(String className) {
        return this.classTransformers.stream().filter(classTransformer -> classTransformer.name.equals(className)).collect(Collectors.toList());
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        List<ClassTransformer> classTransformers = this.getTransformers(name);
        if (!classTransformers.isEmpty()) {
            ClassNode classNode = RebornTransformer.readClassFromBytes(basicClass);
            classTransformers.forEach(classTransformer -> ((ClassTransformer)classTransformer).handle(classNode));
            return RebornTransformer.writeClassToBytes(classNode);
        }
        return basicClass;
    }

    public static ClassNode readClassFromBytes(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    public static byte[] writeClassToBytes(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static class MethodTransformer {
        String name;
        String desc;
        ClassTransformer classTransformer;
        List<Consumer<MethodNode>> methodTransformers = new ArrayList<Consumer<MethodNode>>();

        public MethodTransformer(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public MethodTransformer(ClassTransformer classTransformer) {
            this.classTransformer = classTransformer;
        }

        public ClassTransformer getClassTransformer() {
            return this.classTransformer;
        }

        public MethodTransformer transform(Consumer<MethodNode> methodNodeConsumer) {
            this.methodTransformers.add(methodNodeConsumer);
            return this;
        }

        private void handle(MethodNode methodNode) {
            this.methodTransformers.forEach(methodNodeConsumer -> methodNodeConsumer.accept(methodNode));
        }
    }

    public static class ClassTransformer {
        String name;
        List<MethodTransformer> methodTransformers = new ArrayList<MethodTransformer>();

        public ClassTransformer(String name) {
            this.name = name;
        }

        public MethodTransformer findMethod(String name, String desc) {
            MethodTransformer methodTransformer = new MethodTransformer(name, desc);
            this.methodTransformers.add(methodTransformer);
            return methodTransformer;
        }

        private List<MethodTransformer> getMethodTransformers(MethodNode methodNode) {
            return this.methodTransformers.stream().filter(methodTransformer -> methodTransformer.name.equals(methodNode.name) && methodTransformer.desc.equals(methodNode.desc)).collect(Collectors.toList());
        }

        private void handle(ClassNode classNode) {
            classNode.methods.forEach(methodNode -> this.getMethodTransformers((MethodNode)methodNode).forEach(methodTransformer -> ((MethodTransformer)methodTransformer).handle(methodNode)));
        }
    }
}

