/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLogic;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSandLayers
extends BlockFalling {
    private static final Material SAND_LAYER = new MaterialLogic(MapColor.field_151658_d).func_76231_i();
    public static final PropertyInteger LAYERS = PropertyInteger.func_177719_a((String)"layers", (int)1, (int)8);
    private static final AxisAlignedBB[] SAND_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockSandLayers() {
        super(SAND_LAYER);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf(1)));
        this.func_149672_a(SoundType.field_185855_h);
        this.func_149713_g(0);
        this.func_149711_c(0.1f);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAND_AABB[(Integer)state.func_177229_b((IProperty)LAYERS)];
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)LAYERS) < 5;
    }

    public boolean func_185481_k(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) == 8;
    }

    public boolean isSideSolid(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        IBlockState actualState = this.func_176221_a(state, world, pos);
        return (Integer)actualState.func_177229_b((IProperty)LAYERS) >= 8;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        int i = (Integer)state.func_177229_b((IProperty)LAYERS) - 2;
        i = MathHelper.func_76125_a((int)i, (int)0, (int)8);
        float f = 0.125f;
        AxisAlignedBB axisalignedbb = state.func_185900_c(world, pos);
        return new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, (double)((float)i * f), axisalignedbb.field_72334_f);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World world, @Nonnull BlockPos pos) {
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        Block block = stateDown.func_177230_c();
        if (block != Blocks.field_180401_cv) {
            BlockFaceShape shape = stateDown.func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
            return shape == BlockFaceShape.SOLID || block == this && (Integer)stateDown.func_177229_b((IProperty)LAYERS) == 8;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, @Nonnull BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos)) {
            world.func_175698_g(pos);
        } else {
            super.func_189540_a(state, world, pos, block, fromPos);
        }
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return true;
        }
        IBlockState state = blockAccess.func_180495_p(pos.func_177972_a(side));
        return (state.func_177230_c() != this || (Integer)state.func_177229_b((IProperty)LAYERS) < (Integer)blockState.func_177229_b((IProperty)LAYERS)) && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf((meta & 7) + 1));
    }

    public boolean func_176200_f(IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) - 1;
    }

    public int quantityDropped(IBlockState state, int fortune, @Nonnull Random random) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) + 1;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LAYERS});
    }
}

